/*
stomp_shifter.pde
guest openmusiclabs 7.15.13
this is a pitch shifter program.  it indexes through a sample
buffer at either a slower or faster rate than the incoming
samples.  the buffer boundaries are dealt with by having to samples
being played back simultaneously, each from opposite sides of the
buffer.  the volume of each is set by the distance to the boundary.
the rotary encoder sets the speed of playback.
*/

#include "StompShield.h"

#define SIZE 1000 // make this smaller if it clicks
int buffer[SIZE]; // sample buffer
unsigned int location = 0; // current sample input position
unsigned int offset = 0; // playback sample offset from input
byte button; // button checking timer
byte last_state; // last rotary encoder state
byte counter = 0x80;
unsigned int fractional = 0x80; // fractional sample rate
int data_buffer = 0x80;

void setup() {
  StompShield_init(); // setup the arduino for the shield 
}

void loop() {
}

ISR(TIMER1_OVF_vect) {
  
  // output data
  OCR1AL = ((data_buffer >> 8) + 0x80); 
  OCR1BL = data_buffer; // output the bottom byte
  
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  int input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
  button--; // check buttons every so often
  if (button == 0) {
    byte temp3 = (PIND & 0x94); // mask off and invert
    if (((last_state | temp3) & 0x10) == 0) { // falling edge
      if (temp3 & 0x04) {
        counter++;
        if (counter >= 0xfe) counter = 0xfe;
      }
      else {
        counter--;
        if (counter <= 1) counter = 1;
      }
    }
    last_state = (temp3 ^ 0x94);
    button = 0x20; // reset counter
  }
  
  buffer[location] = input; // store incoming data
  location++; // increment storage location
  if (location >= SIZE) location = 0;  // boundary wrap
  unsigned int temp = location + offset; // find next sample
  if (temp >= SIZE) temp -= SIZE; // boundary wrap
  int output = buffer[temp];  // fetch sample
  temp += (SIZE >> 1);  // find sample on opposite side of buffer
  if (temp >= SIZE) temp -= SIZE; // boundary wrap
  int output2 = buffer[temp]; // fetch sample
  unsigned int distance; // find distance to buffer boundary
  if (offset > (SIZE >> 1)) distance = SIZE - offset;
  else distance = offset;
  int result; // average the 2 samples based on distance to boundary
  MultiSU16X16toH16(result, output, (distance << 7));
  MultiSU16X16toH16(output, output2, (((SIZE >> 1) - distance) << 7));
  output += result;
  fractional += counter; // increment offset
  if (fractional >= 0x0080) {
    offset += (fractional >> 7);
    fractional &= 0x007f;
  }
  if (offset >= SIZE) offset -= SIZE; // boundary wrap

  // save data
  data_buffer = output;
}


