/*
stomp_delay_fast.pde
guest openmusiclabs.com 7.16.13
this is an example program to show how to squeeze a bit more
performance out of your arduino.  you can save up to 80
clock cycles per sample calculation by using these tricks.  that
may not sound like much, but there are only 512 clock cycles
available per sample.  this program plays back a delayed sample.
the delay time is set by the rotary encoder.
*/

#include "StompShield.h"

#define SIZE 1000 // buffer size, make lower if it clicks
int buffer[SIZE]; // data buffer
unsigned int location = 0; // current buffer location
int data_buffer = 0x8000;
byte button;
int counter = SIZE;
byte last_state;

void setup() {
  StompShield_init(); // setup the arduino for the shield
  TIMSK0 = 0; // kill timer0.  this means no delay() or millis()
}

void loop() {
  while(1); // gets rid of jitter
  // nothing happens up here.  if you want to put code up here
  // get rid of the ISR_NAKED and the reti(); below
}

ISR(TIMER1_OVF_vect, ISR_NAKED) { // ISR_NAKED is used to save
// clock cycles, but prohibits code in the loop() section.
  
  // output the last value calculated
  OCR1AL = ((data_buffer + 0x8000) >> 8); // convert to unsigned, send out high byte
  OCR1BL = data_buffer; // send out low byte
  
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  int input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
  button--; // check buttons every so often
  if (button == 0) {
    byte temp3 = (PIND & 0x94); // mask off and invert
    if (((last_state | temp3) & 0x10) == 0) { // falling edge
      if ((temp3 & 0x04) == 0) {
        if (counter >= SIZE) counter = SIZE;
        else counter += 4;
      }
      else {
        if (counter <= 1) counter = 1;
        else counter -= 4;
      }
    }
    last_state = (temp3 ^ 0x94);
    button = 0x20; // reset counter
  }
  
  data_buffer = buffer[location]; // fetch current sample
  buffer[location] = input; // store new sample
  location++; // increment to next location
  if (location >= counter) location = 0; // boundary wrap
  
  reti(); // return from interrupt - required because of ISR_NAKED
}


