/*
stomp_bitcrush.pde
guest openmusiclabs.com 7.15.13
this program reduces the bitdpeth of the incoming signal.  the
bitcrush mask is set by the rotary encoder.
*/

#include "StompShield.h"

int counter; // bit mask
byte button; // button checking timer
byte last_state; // last rotary encoder state

void setup() {
  counter = 0xffff;
  StompShield_init(); // setup the arduino for the shield
}

void loop() {
}

ISR(TIMER1_OVF_vect) {
  
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  int input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
  button--; // check buttons every so often
  if (button == 0) {
    byte temp3 = (PIND & 0x94); // mask off and invert
    if (((last_state | temp3) & 0x10) == 0) { // falling edge
      if (temp3 & 0x04) {
        if ((counter & 0x7fff) == 0) counter = 0x8000;
        else counter <<= 1;
      }
      else counter >>= 1;
    }
    last_state = (temp3 ^ 0x94);
    button = 0x20; // reset counter
  }
  
  input &= counter;
  
  // output data
  OCR1AL = ((input + 0x8000) >> 8); // convert to unsigned and output high byte
  OCR1BL = input; // output the low byte
}


