// StompShield.h
// header file for Stomp Shield for arduino
// guest openmusiclabs.com 7.14.13


#ifndef StompShield_h // include guard
#define StompShield_h

#include <avr/pgmspace.h>
#include "mult16x16.h"
#include "mult16x8.h"
#include "mult32x16.h"
#include "mult8x8.h"

static inline void StompShield_init(void) {

  // setup input pins for rotary encoder
  DDRD &= ~(0x94); // make sure pins 2,4,7 are input
  PORTD |= 0x94; // turn on pullups for pins 2,4,7

  // setup ADC to sample on ADC2
  ADMUX = 0x62; // left adjust, adc2, internal vcc as reference
  ADCSRA = 0xe5; // turn on adc, ck/32, auto trigger
  ADCSRB =0x06; // timer1 overflow as trigger
  DIDR0 = 0x04; // turn off digital inputs for adc2

  // setup PWM to output at 31.25ksps
  TCCR1A = 0xa0; // set to compare mode to positive output
  TCCR1B = 0x11; // ck/1, phase and frequency correct mode, ICR1 as top
  TIMSK1 = 0x01; // turn on overflow interrupt
  ICR1H = 0x00; // clear temporary high byte register
  ICR1L = 0xff; // set top of counter
  DDRB |= 0x06; // set pwm outputs (pins 9,10) to output

}

#endif // end include guard