// guest openmusiclabs 1.3.12
//
// has all signed by unsigned (const8 and int8) except MultiSU8XConst8toH8Round
// only has 1 unsigned by unsigned - MultiU8X8to16


// multiplies 8 bit X 8 bit
// stores lower 8 bits
#define MultiSU8X8toL8(int8Res, sint8In, uint8In) \
asm volatile ( \
"mulsu %1, %2 \n\t"\
"mov %0, r0 \n\t"\
"clr r1"\
: \
"=&r" (int8Res) \
: \
"a" (sint8In), \
"a" (uint8In) \
)

// multiplies 8 bit number X 8 bit constant
// saves lower 8 bit
// 8 cycles
#define MultiSU8XConst8toL8(int8Res, sint8In, uint8In) \
asm volatile ( \
"ldi r22, %2 \n\t"\
"mul %1, r22 \n\t"\
"mov %0, r0 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int8Res) \
: \
"a" (sint8In), \
"M" (uint8In) \
:\
"r22"\
)

// multiplies 8 bit number X 8 bit constant
// saves higher 8 bit
// 8 cycles
#define MultiSU8XConst8toH8(int8Res, sint8In, uint8In) \
asm volatile ( \
"ldi r22, %2 \n\t"\
"mulsu %1, r22 \n\t"\
"mov %0, r1 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int8Res) \
: \
"a" (sint8In), \
"M" (uint8In) \
:\
"r22"\
)

// multiplies 8 bit number X 8 bit and stores high byte
#define MultiSU8X8toH8(int8Res, sint8In, uint8In) \
asm volatile ( \
"mulsu %1, %2 \n\t"\
"mov %0, r1 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int8Res) \
: \
"a" (sint8In), \
"a" (uint8In) \
)

// multiplies 8 bit signed number X 8 bit and stores high bytes
// rounds the number based on the MSB of the lowest byte
#define MultiSU8X8toH8Round(int8Res, sint8In, uint8In) \
asm volatile ( \
"mulsu %1, %2 \n\t"\
"mov %0, r1 \n\t"\
"clr r1 \n\t"\
"lsl r0 \n\t"\
"adc %0, r1 \n\t"\
: \
"=&r" (int8Res) \
: \
"a" (sint8In), \
"a" (uint8In) \
)

// multiplies 8 bit number X 8 bit and stores 2 high bytes
#define MultiSU8X8to16(int16Res, sint8In, uint8In) \
asm volatile ( \
"mulsu %1, %2 \n\t"\
"movw %0, r0 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int16Res) \
: \
"a" (sint8In), \
"a" (uint8In) \
)

// multiplies 8 bit number X 8 bit and stores 2 high bytes
#define MultiS8X8to16(int16Res, int8In1, int8In2) \
asm volatile ( \
"muls %1, %2 \n\t"\
"movw %0, r0 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int16Res) \
: \
"a" (int8In1), \
"a" (int8In2) \
)

// multiplies 8 bit number X 8 bit and stores 2 high bytes
#define MultiU8X8to16(int16Res, int8In1, int8In2) \
asm volatile ( \
"mul %1, %2 \n\t"\
"movw %0, r0 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int16Res) \
: \
"a" (int8In1), \
"a" (int8In2) \
)

// multiplies 8 bit number X 8 bit and stores 2 high bytes
#define MultiU8X8toH8(int8Res, int8In1, int8In2) \
asm volatile ( \
"mul %1, %2 \n\t"\
"mov %0, r1 \n\t"\
"clr r1 \n\t"\
: \
"=&r" (int8Res) \
: \
"a" (int8In1), \
"a" (int8In2) \
)


