/*
stomp_sine.pde
guest openmusiclabs.com 7.14.13
this program just outputs a sinewave.  it does NOT process any audio.
it uses a sinewave lookup table in program memory to create the
output, and the rotary encoder varies the frequency.  this sketch
can be useful if you want to create an audio rate sinewave to test
other equiptment, or to check if your hardware is working.
*/

#include "StompShield.h"

#define B_MAX 1000 // max value for rotary encoder input (min freq)
#define B_MIN 1 // min value for rotary encoder input (max freq)
PROGMEM  prog_int16_t sinewave[]  = {
  // this file is stored in MiniArDSP and is a 1024 value
  // sinewave lookup table of signed 16bit integers
  // you can replace it with your own waveform if you like
  #include <sinetable.inc>
};
unsigned int location; // lookup table value location
unsigned int counter; // rotary encoder value
byte button; // button checking counter
byte last_state; // last rotary encoder steate
int data_buffer; // 1 sample data buffer

void setup() {
  StompShield_init(); // setup the arduino for the shield
}

void loop() {
  // nothing happens here, all down in the interrupt
}

ISR(TIMER1_OVF_vect) { // all processing happens here

  // output the last value calculated
  OCR1AL = ((data_buffer + 0x8000) >> 8); // convert to unsigned, send out high byte
  OCR1BL = data_buffer; // send out low byte
  
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  int input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
  button--; // check buttons every so often
  if (button == 0) {
    byte temp3 = (PIND & 0x94); // mask off button pins
    if (((last_state | temp3) & 0x10) == 0) { // falling edge on pin4
      if ((temp3 & 0x04) == 0) { // low value on pin2
        if (counter > B_MIN) counter--; // if not at min, decrement
      }
      else { // high value on pin2
        if (counter < B_MAX) counter++; // if not at max, increment
      }
    }
    last_state = (temp3 ^ 0x94); // invert buttons states and save
    button = 0x20; // reset counter (determines how often buttons are checked)
  }
  
  // fetch current sample
  data_buffer = pgm_read_word_near(sinewave + location);
  location += counter; // increment location
  location &= 0x03ff; // fast way of doing rollover for 2^n boundary

}


