; frequency sweep generation

in r18,sreg ; store sreg
push r18
lds r19,decay_timer
andi r19,$0f
breq voice1_sweep
pop r18
out sreg,r18 ; restore sreg
reti ; return from interrupt

voice1_sweep: ; process voice1

sbrs r23,$01 ; check if doing decay
rjmp voice2_sweep
lds r0,sweep1_l
lds r1,sweep1_h
lds r18,freq1_l
lds r19,freq1_h
add r18,r0 ; do sweep
adc r19,r1
sts freq1_l,r18
sts freq1_h,r19

voice2_sweep: ; process voice2

sbrs r23,$03 ; check if doing decays
rjmp voice3_sweep
lds r0,sweep2_l
lds r1,sweep2_h
lds r18,freq2_l
lds r19,freq2_h
add r18,r0 ; do sweep
adc r19,r1
sts freq2_l,r18
sts freq2_h,r19

voice3_sweep: ; process voice3

mov r18,r23 ; check if voice active
andi r18,$30
breq voice4_sweep
lds r18,sweep_res
tst r18 ; check if doing resonance sweep
breq voice4_sweep ; skip if not
lds r19,resonance
lds r20,res_stop
lds r21,res_start
cp r20,r21 ; check if sweeping up or down
breq voice4_sweep ; dont do anything if the same
brlo res_sweep_down
add r19,r18
brcc res_sweep_check2
sts resonance,r20 ; top out if overflow
rjmp voice4_sweep

res_sweep_check2:

cp r19,r20 ; check if greater than stop
brlo res_sweep_done
sts resonance,r20
rjmp voice4_sweep

res_sweep_down:

sub r19,r18
brcc res_sweep_check3
sts resonance,r20 ; bottom out if underflow
rjmp voice4_sweep

res_sweep_check3:

cp r19,r20 ; check if less than stop
brsh res_sweep_done
sts resonance,r20 ; bottom out if below stop
rjmp voice4_sweep

res_sweep_done:

sts resonance,r19

voice4_sweep: ; process voice4

sbrs r23,$07 ; check if doing decays
rjmp envelope_done2
lds r0,sweep4_l
lds r1,sweep4_h
lds r18,freq4_l
lds r19,freq4_h
add r18,r0 ; do sweep
adc r19,r1
sts freq4_l,r18
sts freq4_h,r19

sweep_done: ; finish off

pop r18
out sreg,r18 ; restore sreg
reti ; return from interrupt


