; envelope generation
; attacks are processed every interrupt
; decays are processed every n interrupts

in r18,sreg ; store sreg
push r18

decays: ; do attack and decay every nth time

;process voice1
sbrs r23,$00 ; check if doing attacks/decay
rjmp decay1_process2
lds r18,attack1 ; fetch attack rate
add r12,r18
brcc voice2_envelope2 ; check if at top
ser r19
mov r12,r19 ; set envelope to full on
subi r23,$ff ; add b01 to set to sustain (b10)
rjmp voice2_envelope2

decay1_process2: ; process decays

sbrs r23,$01 ; check if doing decay
rjmp voice2_envelope2
lds r0,sweep1_l
lds r1,sweep1_h
lds r18,freq1_l
lds r19,freq1_h
add r18,r0 ; do sweep
adc r19,r1
sts freq1_l,r18
sts freq1_h,r19
lds r18,decay1 ; fetch attack rate
sub r12,r18
brcc voice2_envelope2 ; check if at bottom
clr r12 ; set envelope to full off
andi r23,$fc ; set voice1 ramp to off

voice2_envelope2: ; process voice2

sbrs r23,$02 ; check if doing attacks/decay
rjmp decay2_process2
lds r18,attack2 ; fetch attack rate
add r13,r18
brcc voice3_envelope2 ; check if at top
ser r19
mov r13,r19 ; set envelope to full on
subi r23,$fc ; add b01xx to set to sustain (b10xx)
rjmp voice3_envelope2

decay2_process2: ; process decays

sbrs r23,$03 ; check if doing decays
rjmp voice3_envelope2
lds r0,sweep2_l
lds r1,sweep2_h
lds r18,freq2_l
lds r19,freq2_h
add r18,r0 ; do sweep
adc r19,r1
sts freq2_l,r18
sts freq2_h,r19
lds r18,decay2 ; fetch attack rate
sub r13,r18
brcc voice3_envelope2 ; check if at bottom
clr r13 ; set envelope to full off
andi r23,$f3 ; set voice2 ramp to off

voice3_envelope2: ; process voice3

sbrs r23,$04 ; check if doing attacks
rjmp decay3_process2
lds r20,attack3
add r14,r20 ; increment envelope
brcc voice4_envelope2 ; check if at top
ser r19
mov r14,r19 ; set envelope to full on
subi r23,$f0 ; set envelope to sustain
rjmp voice4_envelope2

decay3_process2: ; process decays

sbrs r23,$05 ; check if doing decays
rjmp voice4_envelope2
;add r6,r0 ; do sweep
;adc r7,r1
lds r20,decay3
sub r14,r20 ; decrement envelope
brcc voice4_envelope2 ; check if at bottom
clr r14 ; set envelope to full off
andi r23,$cf ; set voice3 ramp to off

voice4_envelope2: ; process voice4

sbrs r23,$06 ; check if doing attacks
rjmp decay4_process2
lds r20,attack4
add r15,r20 ; increment envelope
brcc envelope_done2 ; check if at top
ser r19
mov r15,r19 ; set envelope to full on
subi r23,$c0 ; set envelope to sustain
rjmp envelope_done2

decay4_process2: ; process decays

sbrs r23,$07 ; check if doing decays
rjmp envelope_done2
add r8,r0 ; do sweep
adc r9,r1
lds r20,decay4
sub r15,r20 ; decrement envelope
brcc envelope_done2 ; check if at bottom
clr r15 ; set envelope to full off
andi r23,$3f ; set voice4 ramp to off

envelope_done2: ; finish off

pop r18
out sreg,r18 ; restore sreg
reti ; return from interrupt
