; envelope generation
; attacks are processed every interrupt
; decays are processed every n interrupts

in r18,sreg ; store sreg
push r18
lds r19,decay_timer
inc r19
sts decay_timer,r19
andi r19,$01
breq decays

;process voice1
sbrs r23,$00 ; check if doing attacks
rjmp voice2_envelope
lds r20,attack1 ; fetch attack rate
add r12,r20
brcc voice2_envelope ; check if at top
ser r19
mov r12,r19 ; set envelope to full on
subi r23,$ff ; add b01 to set to decay (b10)

voice2_envelope: ; process voice2

sbrs r23,$02 ; check if doing attacks
rjmp voice3_envelope
lds r20,attack2 ; fetch attack rate
add r13,r20
brcc voice3_envelope ; check if at top
ser r19
mov r13,r19 ; set envelope to full on
subi r23,$fc ; add b01xx to set to decay (b10xx)

voice3_envelope: ; process voice3

sbrs r23,$04 ; check if doing attacks
rjmp voice4_envelope
lds r20,attack3
add r14,r20 ; increment envelope
brcc voice4_envelope ; check if at top
ser r19
mov r14,r19 ; set envelope to full on
subi r23,$f0 ; set envelope to decay

voice4_envelope: ; process voice4

sbrs r23,$06 ; check if doing attacks
rjmp envelope_done
lds r20,attack4
add r15,r20 ; increment envelope
brcc envelope_done ; check if at top
ser r19
mov r15,r19 ; set envelope to full on
subi r23,$c0 ; set envelope to decay

envelope_done: ; finish off

pop r18
out sreg,r18 ; restore sreg
reti ; return from interrupt

decays: ; do attack and decay every nth time

;process voice1
sbrs r23,$00 ; check if doing attacks/decay
rjmp decay1_process2
lds r20,attack1 ; fetch attack rate
add r12,r20
brcc voice2_envelope2 ; check if at top
ser r19
mov r12,r19 ; set envelope to full on
subi r23,$ff ; add b01 to set to decay (b10)
rjmp voice2_envelope2

decay1_process2: ; process decays

sbrs r23,$01 ; check if doing decay
rjmp voice2_envelope2
lds r18,amp1_l ; fetch amplitude
lds r19,decay1 ; fetch attack rate
mul r12,r19 ; reduce amplitude in proportion to its value
movw r21:r20,r1:r0
mul r18,r19
add r20,r1
adc r21,r10
mov r12,r21 ; restore amplitude
sts amp1_l,r20
lds r20,sustain1 ; check if below sustain level
cp r12,r20
brsh voice2_envelope2 ; check if at bottom
ldi r20,$02 ; this value sets decay rate below sustain level
sub r12,r20 ; reduce amplitude
brcc voice2_envelope2
clr r12 ; set to bottom
andi r23,$fc ; set voice1 ramp to off

voice2_envelope2: ; process voice2

sbrs r23,$02 ; check if doing attacks/decay
rjmp decay2_process2
lds r20,attack2 ; fetch attack rate
add r13,r20
brcc voice3_envelope2 ; check if at top
ser r19
mov r13,r19 ; set envelope to full on
subi r23,$fc ; add b01xx to set to decay (b10xx)
rjmp voice3_envelope2

decay2_process2: ; process decays

sbrs r23,$03 ; check if doing decays
rjmp voice3_envelope2
lds r18,amp2_l ; fetch amplitude
lds r19,decay2 ; fetch decay rate
mul r13,r19 ; reduce amplitude in proportion to its value
movw r21:r20,r1:r0
mul r18,r19
add r20,r1
adc r21,r10
mov r13,r21
sts amp2_l,r20 ; restore amplitude
lds r20,sustain2 ; check if below sustain level
cp r13,r20
brsh voice3_envelope2
ldi r20,$02 ; this value sets decay rate below sustain level
sub r13,r20 ; reduce amplitude
brcc voice3_envelope2
clr r13 ; set to bottom
andi r23,$f3 ; set voice2 ramp to off

voice3_envelope2: ; process voice3

sbrs r23,$04 ; check if doing attacks
rjmp decay3_process2
lds r20,attack3
add r14,r20 ; increment envelope
brcc voice4_envelope2 ; check if at top
ser r19
mov r14,r19 ; set envelope to full on
subi r23,$f0 ; set envelope to decay
rjmp voice4_envelope2

decay3_process2: ; process decays

sbrs r23,$05 ; check if doing decays
rjmp voice4_envelope2
lds r18,amp3_l ; get amplitude low byte
lds r19,decay3 ; fetch decay rate
mul r14,r19 ; reduce amplitude in proportion to its value
movw r21:r20,r1:r0
mul r18,r19
add r20,r1
adc r21,r10
mov r14,r21 ; restore amplitude
sts amp3_l,r20
lds r20,sustain3 ; check if its below sustain level
cp r14,r20
brsh voice4_envelope2
ldi r20,$02 ; this value sets decay below sustain level
sub r14,r20 ; decrement amplitude
brcc voice4_envelope2
clr r14 ; set to bottom
andi r23,$cf ; set voice ramp to off

voice4_envelope2: ; process voice4

sbrs r23,$06 ; check if doing attacks
rjmp decay4_process2
lds r20,attack4
add r15,r20 ; increment envelope
brcc envelope_done2 ; check if at top
ser r19
mov r15,r19 ; set envelope to full on
subi r23,$c0 ; set envelope to decay
rjmp envelope_done2

decay4_process2: ; process decays

sbrs r23,$07 ; check if doing decays
rjmp envelope_done2
lds r18,amp4_l ; get amplitude low byte
lds r19,decay4 ; fetch decay rate
mul r15,r19 ; reduce amplitude in proportion to its value
movw r21:r20,r1:r0
mul r18,r19
add r20,r1
adc r21,r10
mov r15,r21 ; restore amplitude
sts amp4_l,r20
lds r20,sustain4 ; check if its below sustain level
cp r15,r20
brsh envelope_done2
ldi r20,$02 ; this value sets decay below sustain level
sub r15,r20 ; decrement amplitude
brcc envelope_done2
clr r15 ; set to bottom
andi r23,$3f ; set voice ramp to off

envelope_done2: ; finish off

pop r18
out sreg,r18 ; restore sreg
reti ; return from interrupt
