; main sound generation routines
; mostly multiples amplitudes and signal samples
in r18,gpior0 ; fetch current pwm 
in r19,gpior1
in r20,gpior2
in r21,eedr
out ocr0a,r19 ; send them out to the timer
out ocr0b,r18
sts ocr1al,r21
sts ocr1bl,r20
ldi r18,$80 ; prep registers in case the voice isnt processed
out gpior0,r18
out gpior1,r18
out gpior2,r18
out eedr,r18
in r18,sreg ; store sreg
push r18
push r30 ; store z pointer
push r31

voice1_process: ; process voice1

tst r12 ; check if voice1 active
breq voice2_process
lds r30,freq1_l ; fetch current frequency
lds r31,freq1_h
in r18,eearl ; fetch smaple postion extra low byte
add r18,r30 ; increment to next sample position
adc r2,r31
adc r3,r10
out eearl,r18 ; restore sample position extra low byte
movw r31:r30,r3:r2 ; move to lpm register
lsr r31 ; divde by 2
ror r30
; test mod
lds r18,voice1_mask
and r31,r18 ; adjust size of voice table
lds r18,voice1_boundary
add r31,r18
;
;andi r31,$1f ; adjust for voice table boundary
;ori r31,$60 ; adjust for voice table boundary
lpm r21,z ; fetch current sample
mov r20,r12 ; fetch amplitude
mulsu r21,r20 ; apply amplitude
lds r18,mask1 ; apply bitcrush
and r18,r1
subi r18,$80 ; adjust for pwm
out gpior0,r18 ; store sample

voice2_process: ; process voice2

tst r13 ; check if voice2 active
breq voice3_process
movw r31:r30,r5:r4 ; move to lpm register first to get value of 0 on attack
lds r0,freq2_l ; fetch frequency
lds r1,freq2_h
add r5,r0 ; increment sample position
adc r4,r1
lds r0,fm_mod2_l ; fetch frequency
lds r1,fm_mod2_h
add r5,r0 ; increment sample position
adc r4,r1
lsl r31 ; divide by 32
rol r30
rol r31
rol r30
rol r31
rol r30
rol r31
andi r31,$07 ; mask off lookup table boundary
add r31,r22 ; adjust for voice table boundary
lpm r21,z ; fetch current sample
mov r20,r13 ; fetch amplitude
mulsu r21,r20 ; apply amplitude
lds r18,mask2 ; apply bitcrush
and r18,r1
subi r18,$80 ; adjust for pwm
out gpior1,r18 ; store sample

voice3_process: ; process voice3

tst r14 ; check if voice3 active
breq voice4_process
lsr r7 ; shift random number generator
ror r6
brcc shift_done
ldi r18,$b4
eor r7,r18

shift_done:

lds r18,cutoff_l ; fetch delay time
lds r19,cutoff_h
movw x,y ; make a new pointer
subi xh,$01 ; adjust for boundary offset
sub xl,r18
sbc xh,r19
brcc pointer_done
subi xh,$f9 ; wrap around boundary

pointer_done:

subi xh,$ff ; readjust for boundary offset
mov r21,r7 ; fetch current noise value
lds r20,resonance ; fetch feedback for filter
mulsu r21,r20 ; mix delayed value and current value
movw r19:r18,r1:r0
neg r20
ld r21,x
mulsu r21,r20
sub r18,r0
sbc r19,r1
st y+,r19 ; restore new value
sbrc yh,$03 ; check for buffer overflow
ldi yh,$01
mov r20,r14 ; fetch amplitude
mulsu r19,r20 ; apply amplitude
lds r18,mask3 ; appy bitcrush
and r18,r1
subi r18,$80 ; adjust for pwm
out gpior2,r18 ; store sample

voice4_process: ; process voice4

tst r15 ; check if voice4 active
breq voice_done
movw r31:r30,r9:r8 ; move to lpm register first to get value of 0 on attack
lds r0,freq4_l ; fetch frequency
lds r1,freq4_h
add r9,r0 ; increment sample position
adc r8,r1
lds r0,fm_mod4_l ; fetch fm
lds r1,fm_mod4_h
add r9,r0 ; increment sample position
adc r8,r1
lsl r31 ; divide by 32
rol r30
rol r31
rol r30
rol r31
rol r30
rol r31
andi r31,$07 ; mask off lookup table boundary
add r31,r24 ; adjust for voice table boundary
lpm r21,z ; fetch current sample
mov r20,r15 ; fetch amplitude
mulsu r21,r20 ; apply amplitude
lds r18,mask4 ; apply bitcrush
and r18,r1
subi r18,$80 ; adjust for pwm
out eedr,r18 ; store sample

voice_done:

;finish off
pop r31
pop r30 ; restore z pointer
pop r18
out sreg,r18 ; restore sreg
reti ; return from interrupt


