/*
fixed_delay.pde
for MICrODEC
guest openmusiclabs 8.11.11
this function delays both the left and right channels by a
fixed amount.  the limit to the length of the delay is set
by the external SRAM (512kbytes).  each audio data sample is
16bits, or 2bytes, so at most you can get a 256k sample delay
buffer.  but, since this is in stereo, that is limited to 128k
for each, left and right.  128k/44.1kHz = 2.9s delay.
*/


// setup codec parameters
// must be done before #includes
// see readme file in libraries folder for explanations
#define SAMPLE_RATE 44 // 44.1kHz
#define MOD1 0 // dont use MOD1
#define MOD2 0 // dont use MOD2

// include necessary libraries
#include <Microdec.h>

// create data variables for audio transfer
int left_in = 0x0000;
int left_out = 0x0000;
int right_in = 0x0000;
int right_out = 0x0000;

// create a delay buffer in memory
#define SIZE 0x3abce // 0x3ffff is the max buffer size
                     // this needs to be even for stereo data
unsigned long location = 0; // buffer location to read/write from
// this must be an unsigned long for full address space
// i.e. youre using memwrite() and NOT memwrite16()

void setup() {
  Microdec_init(); // setup codec registers
  // call this last if setting up other parts
}

void loop() {
  while (1); // reduces clock jitter
}

// timer1 interrupt routine - all data processed here
ISR(TIMER0_COMP_vect, ISR_NAKED) { // dont store any registers

  // &'s are necessary on data_in variables
  Microdec_data(&left_in, &right_in, left_out, right_out);
  
  // fetch data from buffer and put it into output register
  // Microdec_memread() takes a 32b address and returns a 16b int
  left_out = Microdec_memread(location);
  // put new data in same location for maximal delay time
  // Microdec_memwrite() takes a 32b address and writes a 16b int to it
  Microdec_memwrite(location++, left_in); // post increment location to go to next memory location
  // repeat for right channel
  right_out = Microdec_memread(location);
  Microdec_memwrite(location++, right_in); // post increment in preperation for next transfer
  // check if location has gotten bigger than buffer size
  if (location >= SIZE) {
    location = 0; // reset location
  }
  // if you are using the full memory space
  // you dont need to do this check, as the memwrite and memread
  // functions automatically truncate the address to 18b
  
  // dont forget to return from interrupt
  reti();
}

