; program: pll-16b.asm
; UID = 000017 - unique id to eliminate conflicts between variables
; 16b address space
; mono data

; program overview
;
; data is read in from the codec, and negative values are inverted to
; positive values.  this value is compared to the current max value, and
; if it is larger, it becomes the new max value.  the max value is
; decremented each sample period to decay the envelope.  left channel
; data is taken in, and its envelope is used to control the gain on an
; iternally generated rampwave.  this is presented on both left and right
; channels.

; constants
;
.equ decay_000017 = $20 ; decay amount per sample period
.equ low_pass_000017 = $0080 ; 1/(lowpass cutoff frequncy) in sample periods (~10Hz)
.equ threshold_000017 = $ff ; comparator threeshold
; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  accumulation lsb
; r3  accumulation mlb
; r4  right/left lsb out/accumulation mhb
; r5  right/left msb out/accumulation msb
; r6  left lsb in
; r7  left msb in
; r8  low pass accumulation lsb
; r9  low pass accumulation mlb
; r10 low pass accumulation mhb
; r11 low pass accumulation msb
; r12 vco control signal lsb
; r13 vco control signal msb
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 sine wave buffer/multiply msb
; r19 sine wave buffer/multiply msb
; r20 current max value lsb/multiply lsb
; r21 current max value msb/multiply msb
; r22 write address high byte/null register
; r23 sinetable lookup address fractional byte
; r24 write address lsb
; r25 write address msb
; r26 sinetable lookup address lsb
; r27 sinetable lookup address msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here first time
; intialize registers
ldi r16,$22 ; increment z pointer to new jump location
ldi r17,$00
add r30,r16
adc r31,r17
mov r8,r17 ; clear accumulation registers
mov r9,r17
mov r10,r17
mov r11,r17
ldi r17,$03 ; initialize vco control setting
mov r13,r17
clr r24 ; clear write register
clr r25
movw r29:r28,r25:r24 ; move write address to read address
subi r28,low(low_pass_000017) ; set read address to lowpass cutoff frequency
sbci r29,high(low_pass_000017)
ldi r22,$00 ; set up write address high byte/null register

clear_000017: ; clear low pass buffer

adiw r29:r28,$01 ; increment read register
out portd,r28 ; set address
sts porth,r29
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r22 ; set data
out portc,r22 ; r22 is cleared above
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines
brne clear_000017 ; continue until end of buffer reached
movw r29:r28,r25:r24 ; move write address to read address
subi r28,low(low_pass_000017) ; set read address to lowpass cutoff frequency
sbci r29,high(low_pass_000017)
reti ; finish with initialization and wait for next interrupt

; program starts here every time but first
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
adiw r29:r28,$01 ; increment read address

wait1_000017: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000017
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000017: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000017
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb

wait3_000017: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000017
in r17,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000017: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000017
in r17,spdr ; recieve in right channel lsb

; vco generation
movw r17:r16,r31:r30 ; store z register
ldi r31,$44 ; setup z register for sinetable lookup in program memory
;get sample 1
add r23,r12 ; increment sinetable address
adc r26,r13
adc r27,r22 ; r22 is cleared above
mov r30,r26
lpm r19,z ; get sine value
sbrs r27,$00 ; flip sign for half of the values
neg r19
;multiply sample 1 by distance
mov r18,r23 ; get distance from sample 1
com r18
mulsu r19,r18 ; (signed)a * b
movw r5:r4,r1:r0
;get sample 2
adiw r27:r26,$01
lpm r19,z ; get sine value
sbrs r27,$00 ; flip sign for half of the values
neg r19
sbiw r27:r26,$01 ; reset sine table register
;multiply sample 2 by distance
mulsu r19,r23 ; (signed)a * b
add r4,r0 ; accumulate result
adc r5,r1
movw r19:r18,r5:r4 ; move result back to sine register
movw r31:r30,r17:r16 ; restore z register

; count zero crossing of data
tst r7
brmi rectify_000017
ldi r17,threshold_000017
cp r6,r17
cpc r7,r22
brsh setregister_000017
rjmp checklevel_000017

rectify_000017:

com r6
com r7
ldi r17,threshold_000017
cp r6,r17
cpc r7,r22
brsh setregister1_000017
rjmp checklevel_000017

setregister1_000017:

brts increment_000017
rjmp checklevel_000017

increment_000017:

clt
ldi r17,$01
add r2,r17
adc r3,r22
;adiw r25:r24,$01
rjmp checklevel_000017

setregister_000017:

set ; set t regiser to indicate first crossing

checklevel_000017: ; check signal level above threshold

cp r6,r20 ; compare signal to current max value
cpc r7,r21
brlt getdata_000017 ; do nothing if below
movw r21:r20,r7:r6 ; move new max value to current max value

getdata_000017:

subi r20,decay_000017 ; decrement envelope for decay
sbc r21,r22 ; r22 is cleared above
;multiply data by envelope
muls r19,r21 ; (signed)ah * (signed)bh
movw r5:r4,r1:r0
mul	r18,r20	; al * bl
movw r17:r16,r1:r0
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22 ; r22 is cleared above
add	r17,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22 ; r22 is cleared above
add	r17,r0
adc	r4,r1
adc	r5,r22

lowpass_000017:

;write data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r4 ; set data
out portc,r5
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines
;accumulate for low pass filtering
ldi r17,$7f ; check if value is negative
cp r17,r5
sbc r11,r22 ; subtract carry in case of negative
add r9,r4 ; add in current value
adc r10,r5
adc r11,r22
;get delayed data
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r0,pina ; get data
in r1,pinc ; get data
;subtract delayed data from accumulator for lowpass filtering
ldi r17,$7f ; check if value is negative
cp r17,r1
adc r11,r22 ; add carry in case of negative
sub r9,r0
sbc r10,r1
sbc r11,r22

switchsample_000017: ; check rotary switch

dec r15
brne done_000017
lds r16,pinj ; get switch data
andi r16,$78 ; mask off rotary switch
ldi r17,$02
lsr r16
lsr r16
add r16,r17 ; adjust switch position to program memory location
cpse r16,r31 ; check if location has changed
clr r30 ; reset jump register to intial state
mov r31,r16
inc r14
ldi r17,$10
cp r14,r17
brne done_000017
lsl r2
rol r3
lsl r2
rol r3
lsl r2
rol r3
lsl r2
rol r3
lsl r2
rol r3
;ldi r17,$0f
;and r6,r17
;add r24,r6
;adc r25,r22
movw r13:r12,r3:r2
clr r2
clr r3
clr r14

done_000017:

movw r5:r4,r11:r10
reti

