; program: delay-18b-pot.asm
; UID = 000004 - unique id to eliminate conflicts between variables
; 18b address space (3s delay time)
; stereo data
; pot controlled delay time (3ms - 3s)

; program overview
;
; data is read in from memory and written out the codec at the same time
; new data is written to the memory from the codec.  ADC0 is read and
; averaged over 256 samples to reduce jitter.  this value is subtracted
; from the write address to create the desired read address.  if the actual
; read address doesnt match the desired read address, it is either
; incremented or decremented by one sample each sample period until it
; matches.  this reduces noise during delay time transitions.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 adc accumulator lsb
; r11 adc accumulator msb
; r12 actual delay lsb
; r13 actual delay msb
; r14 adc sample counter
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 null register
; r19 adc accumulatot fractional byte
; r20 
; r21 actual delay fractional byte
; r22 write address third byte
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 desired delay lsb
; r27 desired delay msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb0
ldi r18,$00 ; clear r18 for carry addition and ddr setting
adiw r25:r24,$01 ; increment write address
adc r22,r18 ; increment write third byte
andi r22,$03 ; mask off unsed bits
adiw r29:r28,$01 ; increment read address
adc r23,r18 ; increment read third byte
andi r23,$03 ; mask off unsed bits
ori r23,$04 ; set we bit for reading

wait1_000004: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000004
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb
;get left channel data from sram
out portg,r23 ; pull ce low, we high, and set high bits of register
out portd,r28 ; set address
sts porth,r29
adiw r29:r28,$01 ; increment read address - placed here to use setup time efficiently
adc r23,r18 ; increment read third byte
andi r23,$03 ; mask off unsed bits
ori r23,$04 ; set we bit for reading
in r2,pina ; get data
in r3,pinc ; get data

wait2_000004: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000004
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r18 ; set porta as input for data lines
out ddrc,r18 ; set portc as input for data lines

wait3_000004: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000004
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portg,r23 ; pull ce low,we high,oe low, and set high bits of address
out portd,r28 ; set address
sts porth,r29
adiw r25:r24,$01 ; increment write address - placed here for efficient use of setup time
adc r22,r18 ; increment write third byte
andi r22,$03 ; mask off unsed bits
in r4,pina ; get data
in r5,pinc ; get data

wait4_000004: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000004
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
sbi portg,portg2 ; pull we high to write
out ddra,r18 ; set porta as input for data lines
out ddrc,r18 ; set portc as input for data lines

; get delay settings
lds r17,adcsra ; get adc control register
sbrs r17,adif ; check if adc conversion is complete
rjmp shift_000004 ; skip adc sampling
lds r16,adcl ; get low byte adc value
lds r17,adch ; get high byte adc value
add r19,r16 ; accumulate adc samples
adc r10,r17
adc r11,r18 ; r18 is cleared above
ldi r17,$f7
sts adcsra,r17 ; clear interrupt flag
dec r14 ; countdown adc sample clock
brne shift_000004 ; get delay time if its been long enough
cp r10,r18 ; check if adc value is 0
cpc r11,r18 ; r18 is cleared at top of function
brne deadband_000004 ; check if adc value changed enough to update delay
inc r10 ; set minimum delay to $000100 = 5ms

deadband_000004: ; set the low value of the delay

movw r17:r16,r11:r10 ; move adc sample to temporary register
sub r16,r26 ; find difference between adc sample and desired delay time
sbc r17,r27
brsh check_000004 ; check for deadband if positive
neg r16 ; invert if negative
adc r17,r18 ; r18 is cleared above
neg r17

check_000004: ; check if difference is greater than deadband

cpi r16,$02 ; check if difference is less than $03
cpc r17,r18 ; r18 cleared above
brlo empty_000004 ; do nothing if less than $03
movw r27:r26,r11:r10 ; move adc sample to delay time if large enough change

empty_000004: ; empty accumulation registers and finish off

clr r10 ; empty accumulation registers
clr r11
clr r19

shift_000004: ; check if delay time is correct

cp r18,r21 ; compare desired delay to actual delay
cpc r26,r12
cpc r27,r13
breq switchsample_000004 ; do nothing if the same
brlo indexdown_000004
ldi r17,$04 ; increment delay register
add r21,r17
adc r12,r18 ; r18 is cleared above
adc r13,r18
ldi r17,$03
and r13,r17 ; mask off unused bits
rjmp switchsample_000004

indexdown_000004:

subi r21,$02 ; decrement delay register
sbc r12,r18 ; r18 is cleared above
sbc r13,r18
ldi r17,$03
and r13,r17 ; mask off unused bits

switchsample_000004: ; check state of rotary switch

dec r15
brne done_000004
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02 ; adjust switch position to program memory location
lsr r31
lsr r31
add r31,r17 ; move to jump register

done_000004:

movw r29:r28,r25:r24 ; move write address to read destination register
mov r23,r22 ; move write third byte to read third byte
andi r21,$fe ; make sure delay time is even
sub r28,r21 ; subtract delay time
sbc r29,r12
sbc r23,r13
andi r23,$03 ; mask off unsed bits
ori r23,$04 ; set we bit for reading
reti

