; program: upsweep-16b-pot.asm
; UID = 000005 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; stereo data
; pot controlled sample time (0s - .7s)

; program overview
;
; data is read in from memory and written out the codec at the same time
; new data is written to the memory from the codec.  the write address
; increments until it reaches the top of the buffer and then starts at
; zero.  the read address does the same thing, but at twice the rate,
; doubling all the frequencies in the sample bufer.  ADC0 is read and
; averaged over 256 samples.  this value is used to set the top of the
; sample buffer.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 adc accumulator fractional byte
; r11 adc accumulator lsb
; r12 
; r13 
; r14 adc sample counter
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 adc accumulator msb
; r20 
; r21 
; r22 write address third byte/null register
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 buffer size lsb
; r27 buffer size msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
adiw r29:r28,$03 ; increment read address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000005: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000005
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel 
;get left channel data from sram
out portg,r23 ; pull ce low, we high, and set high bits of register
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r3,pinc ; get data
adiw r29:r28,$01 ; increment read address

wait2_000005: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000005
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000005: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000005
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data
adiw r25:r24,$01 ; increment write address

wait4_000005: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000005
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

; get loop setting
lds r17,adcsra ; get adc control register
sbrs r17,adif ; check if adc conversion is complete
rjmp writecheck_000005 ; skip adc sampling
lds r17,adcl ; get low byte adc value
lds r16,adch ; get high byte adc value
add r10,r17
adc r11,r16 ; accumulate adc samples
adc r19,r22 ; accumulate adc samples - r22 is cleared above
ldi r17,$f7
sts adcsra,r17 ; clear interrupt flag
dec r14 ; countdown adc sample clock
breq adcsample_000005 ; get adc value if its been long enough
dec r15 ; countdown switch clock
breq switchsample_000005

writecheck_000005: ; check if over loop length

cp r24,r26 ; compare write address to loop length
cpc r25,r27
brlo readcheck_000005 ; reset write address to bottom of loop if over
clr r24 ; set write address to bottom
clr r25

readcheck_000005: ; check if over loop length

cp r28,r26 ; compare write address to loop length
cpc r29,r27
brlo done_000005 ; reset write address to bottom of loop if over
clr r28 ; set read address to bottom
clr r29

done_000005:

reti

adcsample_000005: ; get adc value and change decay time

lsr r19 ; divide accumulated value by 4
ror r11
ror r10
lsr r19
ror r11
ror r10
ldi r17,$fe ; make sure the loop time is even (set lsb to 0)
and r10,r17
movw r27:r26,r11:r10 ; move adc value to loop time register
clr r10 ; empty accumulation registers
clr r11
clr r19
rjmp writecheck_000005

switchsample_000005: ; check switch position

lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location
rjmp writecheck_000005

