; program: pseudo_convolver-16b.asm
; UID = 000026 - unique id to eliminate conflicts between variables
; 16b address space (.7s delay time)
; mono data

; program overview
;
; data is written to the memory as it arrives from the codec.  data is
; read in from the memory and muliplied by a fixed constant.  this is
; done for 10 delay times with different constants, and the result is
; accumulated and played out.  data is taken in on the left channel, and
; played out on both left and right.

; convolution tap seperation
;
.equ tap_seperation_000026 = $3e ; (max value is $3f)

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  accumulate byte0
; r3  accumulate byte1
; r4  right/left lsb out/accumulate byte2
; r5  right/left msb out/accumulate byte3
; r6  left lsb in
; r7  left msb in
; r8  input address storage lsb
; r9  input address storage msb
; r10 sample address storage lsb
; r11 sample address storage msb
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 tap multiply constant lsb
; r19 tap multiply constant msb
; r20 audio data multiply lsb
; r21 audio data multiply msb
; r22 write address third byte/null register
; r23 
; r24 input data address lsb
; r25 input data address msb
; r26 
; r27 
; r28 sample address lsb
; r29 sample address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$02 ; increment input address
adiw r29:r28,$02 ; increment sample address
ori r28,$01 ; make sure sample address is odd
movw r11:r10,r29:r28 ; store sample address as it gest modified later
movw r9:r8,r25:r24 ; store input address as it gets modified later
ldi r22,$00 ; set up high byte write register

wait1_000026: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000026
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb
out portg,r23 ; pull ce low, we high, and set high bits of register

wait2_000026: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000026
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

wait3_000026: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000026
in r17,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

;clear accumulation registers
clr r5
clr r4
clr r3
clr r2

wait4_000026: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000026
in r17,spdr ; recieve in left channel lsb

;get delayed input data - sample 1
sbiw r25:r24,tap_seperation_000026 ; get first data word
out portd,r24 ; set address
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 2
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 3
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 4
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 5
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 6
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 7
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
sbiw r25:r24,tap_seperation_000026 ; get next data word - placed here to efficiently use the 2 cycle setup time
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

;get delayed input data - sample 8
out portd,r24 ; set address - decremented in previous section
sts porth,r25
adiw r29:r28,tap_seperation_000026 ; get next data word - placed here to efficiently use 2 cycle setup time
in r20,pina ; get data
in r21,pinc ; get data

;get delayed sample data
out portd,r28 ; set address
sts porth,r29
movw r25:r24,r9:r8 ; reset input address - placed here to efficiently use the 2 cycle setup time
movw r29:r28,r11:r10 ; reset sample address
in r18,pina ; get data
in r19,pinc ; get data

;multiply and accumulate - r5:r4:r3:r2
muls r19,r21 ; (signed)ah * (signed)bh
add	r4,r0
adc	r5,r1
mul	r18,r20 ; al * bl
add	r2,r0
adc	r3,r1
adc	r4,r22 ; r22 is cleared above
adc	r5,r22
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22
add	r3,r0
adc	r4,r1
adc	r5,r22

switchsample_000026: ; sample rotary switch to check for program change

dec r15
brne done_000026
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000026:

reti

