; program: delay-16b-pot.asm
; UID = 000003 - unique id to eliminate conflicts between variables
; 16b address space (.7s delay time)
; stereo data
; pot controlled delay time (0s - .7s)

; program overview
;
; data is read in from memory and written out the codec at the same time
; new data is written to the memory from the codec.  ADC0 is read and
; averaged over 256 samples to reduce jitter.  this value is subtracted
; from the write address to create the desired read address.  if the actual
; read address doesnt match the desired read address, it is either
; incremented or decremented by one sample each sample period until it
; matches.  this reduces noise during delay time transitions.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 adc accumulator fractional byte
; r11 adc accumulator lsb
; r12 actual delay lsb
; r13 actual delay msb
; r14 adc sample counter
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 adc accumulator msb
; r20 
; r21 
; r22 write address third byte/null register
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 desired delay lsb
; r27 desired delay msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
adiw r29:r28,$01 ; increment read address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000003: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000003
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb
;get left channel data from sram
out portg,r23 ; pull ce low, we high, and set high bits of register
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r3,pinc ; get data
adiw r29:r28,$01 ; increment read address

wait2_000003: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000003
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000003: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000003
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data
adiw r25:r24,$01 ; increment write address

wait4_000003: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000003
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

; get delay settings
lds r17,adcsra ; get adc control register
sbrs r17,adif ; check if adc conversion is complete
rjmp shift_000003 ; skip adc sampling
lds r17,adcl ; get low byte adc value
lds r16,adch ; get high byte adc value
add r10,r17
adc r11,r16 ; accumulate adc samples
adc r19,r22 ; accumulate adc samples - r22 is cleared above
ldi r17,$f7
sts adcsra,r17 ; clear interrupt flag
dec r14 ; countdown adc sample clock
breq adcsample_000003 ; get adc value if its been long enough
dec r15 ; countdown switch clock
breq switchsample_000003

shift_000003: ; check if delay time is correct

cp r26,r12 ; compare desired delay to actual delay
cpc r27,r13
breq done_000003 ; do nothing if the same
brlo indexdown_000003
ldi r17,$02 ; increment delay register register
add r12,r17
adc r13,r22 ; r22 is cleared at top of function
rjmp done_000003

indexdown_000003:

ldi r17,$04 ; decrement delay register register
sub r12,r17
sbc r13,r22 ; r22 is cleared at top of function
rjmp done_000003

adcsample_000003: ; get adc value and change decay time

lsr r19 ; divide accumulated value by 4
ror r11
ror r10
lsr r19
ror r11
ror r10
ldi r17,$fe ; make sure the delay time is even (set lsb to 0)
and r10,r17
movw r27:r26,r11:r10 ; move adc value to desired delay register
clr r10 ; empty accumulation registers
clr r11
clr r19
rjmp shift_000003 ; finish off

done_000003:

movw r29:r28,r25:r24 ; move write address to read destination register
sub r28,r12 ; subtract delay time
sbc r29,r13
reti

switchsample_000003: ; check switch position

lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location
rjmp shift_000003

