; program: up_downsweep-16b.asm
; UID = 000007 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; stereo data

; program overview
;
; data is read in from memory and written out to the codec at the same time
; new data is written to the memory from the codec.  the write address
; increments until it reaches the top of the buffer and then starts at
; zero.  the read address increases at twice the rate until it reaches the
; write address, and then decreases until it reaches the write address.
; it continues this back and forth sample playback.  this program has a
; section which must be placed before the interrupt jump location.  this
; is similar to a program which must be initialized once before running.
; to accomplish this while still maintaining generality, the z register is
; updated upon intialization to point to the actual program start.  this
; program start can either be found by counting up the number of words
; each instruction takes, or by compiling the program and looking at the
; assembled object and finding the location of the instruction.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 
; r11 
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 
; r20 
; r21 
; r22 write address third byte
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 
; r27 
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here first time
; initialze z pointer for correct jump
; this assumes a less than 256 word jump
ldi r16,$10 ; increment z pointer to new jump location
ldi r17,$00
add r30,r16
adc r31,r17
reti ; finish with initialization and wait for next interrupt

reverse_000007:

sbiw r29:r28,$01 ; decrement read address
cp r28,r24 ; check if read address moved past the write address
cpc r29,r25
breq forward_000007
sbiw r29:r28,$02 ; decrement read address
cp r28,r24 ; check if read address moved past the write address
cpc r29,r25
brne wait1_000007

forward_000007:

clt ; clear t register to indicate forward mode
adiw r29:r28,$02 ; move forward a step
rjmp wait1_000007 ; continue with data writes

; initiate data transfer to codec
; this is the point the z-pointer is incremented to
; program starts here all but first time
sbi portb,portb0 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb0
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register
adiw r25:r24,$01 ; increment write address
brts reverse_000007
adiw r29:r28,$03 ; increment read address
cp r28,r24 ; check if read address moved past the write address
cpc r29,r25
brne wait1_000007 ; continue if no match
sbiw r29:r28,$02 ; back up a step
set ; set t register to indicate reverse mode

wait1_000007: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000007
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb
;get left channel data from sram
out portg,r23 ; pull ce low, we high, and set high bits of register
;cbi portb,portb7 ; pull oe low - should be low already, uncomment if neccesary
;set data lines as input should also already be done, but do so here if not
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r3,pinc ; get data
adiw r29:r28,$01 ; increment read address

wait2_000007: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000007
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000007: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000007
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data
adiw r25:r24,$01 ; increment write address

wait4_000007: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000007
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

; check if at same function
dec r15
brne done_000007
lds r16,pinj ; get switch data
andi r16,$78 ; mask off rotary switch
ldi r17,$02
lsr r16
lsr r16
add r16,r17 ; adjust switch position to program memory location
cpse r16,r31 ; check if location has changed
clr r30 ; reset jump register to intial state
mov r31,r16

done_000007:

reti

