; program: pitch_shifter-16b-ducking.asm
; UID = 000020 - this is a unique id so variables dont conflict
; 16b address space with mono data (1.5s sample time)
; pitch shifter - loops past n seconds at a higher or lower rate to change
; the apparent pitch of the sound - rotary encoder controlled playback speed

; program overview
;
; data is sent out and taken in from the codec.  data is taken in on the
; left channel, and played out on both left and right.  a buffer of the
; past n seconds is kept and the output is the result of sampling this
; buffer at varying playback speeds. the speed at which it plays through
; the memory is controlled by the rotary encoder.  turning the encoder to
; the right slows playback down, and turning it the left speeds playback up.  the
; audio is kept clean over fractional sample periods by interpolating
; between the two closest samples.

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  left/right lsb out
; r3  left/right msb out
; r4  rotary encoder pin0 debounce register
; r5  rotary encoder pin1 debounce register
; r6  left lsb in/multiply accumulation lsb
; r7  left msb in/multiply accumulation msb
; r8  multiply acccumulation fractional register
; r9  pushbutton debounce register
; r10 adc lsb accumulator/encoder0 buffer
; r11 adc msb accumulator/encoder1 buffer
; r12 playback speed increment lsb value ($0100 is normal speed)
; r13 playback speed increment msb value
; r14 
; r15 switch counter
; r16 temporary swap register
; r17 temporary swap register
; r18 signed multiply register
; r19 signed multiply register
; r20 unsigned multiply register
; r21 unsigned multiply register
; r22 write address third byte/null register
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 
; r27 
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; constant definitions
;
.equ step_size_000020 = $14 ; this is the amount a single detent on the rotary
; encoder changes the read address increment by.  each bit is 1/256 of
; normal playback speed.

; program begins here
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb5
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000020: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000020
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000020: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000020
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

wait3_000020: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000020
in r17,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r18,pina ; get data
in r19,pinc ; get data

wait4_000020: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000020
in r17,spdr ; recieve in right channel lsb

;increment read and write addresses
adiw r25:r24,$01 ; increment write address
cp r24,r26 ; check if at end of buffer
cpc r25,r27
brlo readinc_000020 ; do nothing if not at end of buffer
clr r24 ; reset buffer to bottom
clr r25

readinc_000020: ; increment read address

adiw r29:r28,$02 ; increment read address
cp r28,r26 ; check if at end of buffer
cpc r29,r27
brlo duck_000020 ; do nothing if not at end of buffer
clr r28 ; reset buffer to bottom
clr r29

duck_000020: ; check if time for ducking

movw r21:r20,r29:r28 ; move read address to temporary register
sub r20,r24 ; find distance to loop boundary
sbc r21,r25
brcc half_000020 ; check if result is negative
neg r20 ; invert distance if negative
adc r21,r22 ; r22 is cleared above
neg r21

half_000020: ; check if result is greater than half the buffer size

lsr r27 ; divide buffer size by 2
ror r26
cp r20,r26 ; check if result is greater than half the buffer size
cpc r21,r27
brlo reset_000020 ; skip flip if not
lsl r26 ; reset buffer size
rol r27
sub r20,r26 ; flip result around boundary
sbc r21,r27
neg r20
adc r21,r22 ; r22 is cleared above
neg r21
rjmp attenuate_000020

reset_000020: ; reset buffer

lsl r26 ; reset buffer size
rol r27

attenuate_000020: ; multiply signal by distance to boundary

movw r5:r4,r19:r18 ; mov data to output buffer in case no multiply is required
cpi r21,$01 ; check if distance is great than $0080
brsh rotary_000020 ; do nothing if not
;cpi r20,$80
;brsh switchsample_000020 ; do nothing if not
;lsl r20 ; multiply distance by 2 for scaling
;multiply by distance if less than $0100
mulsu r19,r20 ; (signed)ah * b
movw r5:r4,r1:r0
mul	r18,r20	; al * b
add	r4,r1
adc	r5,r22 ; r22 is cleared above
rjmp rotary_000020

;swap r21 ; multiply distance by 16 for scaling
;swap r20
;mov r17,r20
;andi r20,$f0
;andi r17,$0f
;or r21,r17
;;multiply data by distance
;muls r19,r21 ; (signed)ah * (signed)bh
;movw r5:r4,r1:r0
;mul	r18,r20	; al * bl
;movw r3:r2,r1:r0
;mulsu r19,r20 ; (signed)ah * bl
;sbc	r5,r22 ; r22 is cleared above
;add	r3,r0
;adc	r4,r1
;adc	r5,r22
;mulsu r21,r18 ; (signed)bh * al
;sbc	r5,r22 ; r22 is cleared above
;add	r3,r0
;adc	r4,r1
;adc	r5,r22

;get sample from opposite side of buffer
;subi r29,$02 ; move read address to halfway back in buffer
;andi r29,$03
;out portd,r28 ; set address
;sts porth,r29
;nop ; wait input latch time of 2 clock cycles
;nop ; wait input latch time of 2 clock cycles
;in r18,pina ; get data
;in r19,pinc ; get data
;;check read address to see if time for fading
;movw r21:r20,r29:r28 ; move read address to temporary register
;subi r29,$02 ; move read address back
;andi r29,$03 ; mask off high bits for max buffer size of $0800
;sub r20,r24 ; find distance to loop boundary
;sbc r21,r25
;brpl half1_000020 ; check if result is negative
;com r20 ; invert distance if negative
;com r21
;
;half1_000020: ; check if result is greater than half the buffer size
;
;cpi r21,$02 ; check if result is greater than half the buffer size
;brlo attenuate1_000020 ; skip flip if not
;com r20 ; flip distance around center of buffer
;ldi r17,$03
;eor r21,r17
;
;attenuate1_000020: ; multiply signal by distance to boundary
;
;swap r21 ; multiply distance by 16 for scaling
;swap r20
;mov r17,r20
;andi r20,$f0
;andi r17,$0f
;or r21,r17
;multiply and accumulate with result from above - r5:r4:r3:r2
;muls r19,r21 ; (signed)ah * (signed)bh
;add	r4,r0
;adc	r5,r1
;mul	r18,r20 ; al * bl
;add	r2,r0
;adc	r3,r1
;adc	r4,r22
;adc	r5,r22
;mulsu r19,r20 ; (signed)ah * bl
;sbc	r5,r22
;add	r3,r0
;adc	r4,r1
;adc	r5,r22
;mulsu r21,r18 ; (signed)bh * al
;sbc	r5,r22
;add	r3,r0
;adc	r4,r1
;adc	r5,r22
;rjmp switchsample_000020
;
;check pushbutton
;lds r16,pinj ; get pushbutton data
;bst r16,$02 ; debounce pushbutton
;lsl r9
;bld r9,$00
;ldi r17,$ff ; check if button not pressed
;cp r9,r17
;breq interpolate_000020 ; playback if button is not depressed
;movw r29:r28,r25:r24 ; synchronize read and write addressses
;adiw r25:r24,$01 ; increment write address
;;write left channel data to sram
;out portd,r24 ; set address
;sts porth,r25
;out portg,r22 ; pull ce low,we low,and set high bits of address
;ldi r17,$ff
;out ddra,r17 ; set porta as output for data write
;out ddrc,r17 ; set portc as output for data write
;out porta,r6 ; set data
;out portc,r7
;ldi r17,$00 ; prepare for setting ports a,c as input
;sbi portg,portg2 ; pull we high to write
;out ddra,r17 ; set porta as input for data lines
;out ddrc,r17 ; set portc as input for data lines
;movw r3:r2,r7:r6 ; pass data through while recording
;ldi r17,$01 ; set playback speed to normal
;mov r12,r22 ; r22 is cleared above
;mov r13,r17

switchsample_000020: ;check switch

tst r15
brne done_000020
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location
ldi r17,$20
mov r15,r17

done_000020:

reti

interpolate_000020: ; interpolate data based upon speed setting

add r21,r12 ; increment read register
adc r28,r13
adc r29,r22 ; r22 is cleared above
;get left channel sample 1 data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r19,pinc ; get data
adiw r29:r28,$01 ; increment read register
;get left channel sample 2 data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r3,pina ; get data
in r18,pinc ; get data
sbiw r29:r28,$01 ; reset read register

;multiply sample 1 by distance
mov r16,r21 ; get distance from sample 1
com r16
mulsu r19,r16 ; (signed)ah * b
movw r7:r6,r1:r0
mul	r2,r16	; al * b
add	r6,r1
adc	r7,r22 ; r22 is cleared above
mov r8,r0

;multiply sample 2 by distance
mulsu r18,r21 ; (signed)ah * b
add r6,r0 ; accumulate result
adc r7,r1
mul	r3,r21	; al * b
add r8,r0 ; accumulate result
adc	r6,r1
adc	r7,r22 ; r22 is cleared above
movw r3:r2,r7:r6 ; move result to ouput registers

rotary_000020: ; check rotary encoder

dec r15
brne switchsample_000020
lds r17,pinj ; get switch data
bst r17,$00 ; debounce pin0 of encoder
lsl r10
bld r10,$00
bst r17,$01 ; debounce pin1 of encoder
lsl r11
bld r11,$00
tst r11 ; see if pin1 is low
breq edge_000020
ldi r17,$ff ; check if fully high
cp r11,r17
brne switchsample_000020 ; do nothing if not fully high
ldi r16,$01 ; set previous state to current state
rjmp switchsample_000020

edge_000020: ; check for falling edge

sbrs r16,$00 ; check if previous state was high
rjmp switchsample_000020 ; do nothing if no state change
ldi r16,$00 ; clear register
sbrc r10,$00 ; check average state of pin1
inc r16
sbrc r10,$01
inc r16
sbrc r10,$02
inc r16
sbrc r10,$03
inc r16
sbrc r10,$04
inc r16
sbrc r10,$05
inc r16
sbrc r10,$06
inc r16
sbrc r10,$07
inc r16
cpi r16,$04 ; check average value of pin1
ldi r16,$00 ; reset previous state register
brlt increment_000020 ; increment if a backwards rotation
ldi r17,step_size_000020 ; decrement read register
sub r26,r17
sbc r27,r22 ; r22 is cleared above
rjmp switchsample_000020

increment_000020:

ldi r17,step_size_000020 ; increment read register
add r26,r17
adc r27,r22 ; r22 is cleared above
rjmp switchsample_000020 ; finish off

