; program: fullwave.asm
; UID = 000010 - unique id to eliminate conflicts between variables
; stereo data

; program overview
;
; data is read in from the codec, and negative values are inverted to
; positive values.  all values are then shifted down to mid-rail and
; multiplied by 2 to normalize the output.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left out lsb
; r3  left out msb
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 
; r11 
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 
; r20 
; r21 
; r22 
; r23 
; r24 
; r25 
; r26 
; r27 
; r28 
; r29 
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb0

wait1_000010: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000010
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb

wait2_000010: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000010
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb

wait3_000010: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000010
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000010: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000010
in r8,spdr ; recieve in left channel lsb

;fullwave rectify right data
sbrs r9,$07 ; check if negative
rjmp leftdata_000010 ; check left data
com r8 ; invert data if negative (using ones complement to avoid problem at $8000)
com r9

leftdata_000010: ; fullwave rectify left data

sbrs r7,$07 ; check if negative
rjmp switchsample_000010
com r6 ; invert data if negative (using ones complement to avoid problem at $8000)
com r7

switchsample_000010: ; check rotary switch

dec r15
brne done_000010
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000010: ; normalize data and move to read buffer

ldi r17,$40 ; shift values down to midrange
sub r9,r17
sub r7,r17
lsl r8 ; multiply by two
bst r9,$07 ; preserve sign
rol r9
bld r9,$07
lsl r6 ; multiply by two
bst r7,$07 ; preserve sign
rol r7
bld r7,$07
movw r5:r4,r9:r8 ; move data to read registers
movw r3:r2,r7:r6
reti

