; program: flanger-16b.asm
; UID = 000025 - unique id to eliminate conflicts between variables
; 16b address space (1.5s sample time)
; mono data

; program overview
;
; data is read in from the codec and placed into memory.  data is taken
; out of memory from a time varying position.  this position has an offset
; which is increased at a fixed rate until it reaches its maximum value,
; at which point it is decreased until it reaches its minimum value.
; data is taken in on the left channel, and presented on both left and
; right out.

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  lfo increment
; r3  rotary encoder sample counter
; r4  left/right lsb out
; r5  left/right msb out
; r6  left lsb in
; r7  left msb in
; r8  
; r9  
; r10 max lfo depth lsb
; r11 max lfo depth msb
; r12 adc accumulation lsb
; r13 adc accumulation msb
; r14 adc accumulation fractional byte
; r15 switch/adc sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 signed multiply register
; r19 signed multiply register
; r20 rotary enooder state
; r21 lfo depth fractional byte
; r22 write address third byte/null register
; r23 
; r24 write address lsb
; r25 write address msb
; r26 minimum delay time lsb
; r27 minimum delay time msb
; r28 lfo depth lsb
; r29 lfo depth msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
ldi r22,$00 ; set up high byte write register

;for testing
ldi r17,$02
mov r26,r17
mov r27,r17

wait1_000025: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000025
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000025: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000025
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

wait3_000025: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000025
in r17,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000025: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000025
in r17,spdr ; recieve in left channel lsb

;calculate lfo delay time
brts upcount_000025 ; check if up counting
sub r21,r2 ; subtract lfo increment from delay time
sbc r28,r22 ; r22 is cleared above
sbc r29,r22
brcc getdata_000025 ; continue if not at bottom
set ; set t register to indicate up counting

upcount_000025: ; increment delay time

add r21,r2 ; add lfo increment to delay time
adc r28,r22 ; r22 is cleared above
adc r29,r22
cp r28,r10 ; check if max depth reached
cpc r29,r11
brlo getdata_000025 ; continue if not at max depth
clt ; clear the t register to indicate down counting

getdata_000025: ; get left channel data from sram

movw r17:r16,r25:r24 ; set read register to current position
sub r16,r26 ; subtract minimum delay
sbc r17,r27
sub r16,r28 ; subtract lfo depth
sbc r17,r29

;interpolate data based upon delay setting
;get left channel sample 1 data from sram
out portd,r16 ; set address
sts porth,r17
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r6,pina ; get data
in r19,pinc ; get data
ldi r18,$01 ; decrement read register
sub r16,r18
sbc r17,r22 ; r22 is cleared above
;get left channel sample 2 data from sram
out portd,r16 ; set address
sts porth,r17
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r7,pina ; get data
in r18,pinc ; get data

;multiply sample 1 by distance
mov r16,r21 ; get distance from sample 1
com r16
mulsu r19,r16 ; (signed)ah * b
movw r5:r4,r1:r0
mul	r6,r16	; al * b
mov r17,r0
add	r4,r1
adc	r5,r22 ; r22 is cleared above

;multiply sample 2 by distance
mulsu r18,r21 ; (signed)ah * b
add r4,r0 ; accumulate result
adc r5,r1
mul	r7,r21	; al * b
add r17,r0 ; accumulate result
adc	r4,r1
adc	r5,r22 ; r22 is cleared above

; get minimum delay setting
lds r17,adcsra ; get adc control register
sbrs r17,adif ; check if adc conversion is complete
rjmp rotary_000025 ; skip adc sampling
lds r16,adcl ; get low byte adc value
lds r17,adch ; get high byte adc value
add r12,r16 ; accumulate adc samples
adc r13,r17
adc r14,r22 ; r22 is cleared above
ldi r17,$f7
sts adcsra,r17 ; clear interrupt flag
dec r15 ; countdown adc sample clock
brne rotary_000025 ; get delay time if its been long enough
cp r13,r22 ; check if adc value is 0
cpc r14,r22 ; r22 is cleared at top of function
brne deadband_000025 ; check if adc value changed enough to update delay
inc r13 ; set minimum adc value to $000100

deadband_000025: ; set the low value of the delay

lsr r14 ; divide adc value by 8
ror r13
ror r12
lsr r14
ror r13
ror r12
lsr r13
ror r12
;ldi r17,$e0
;and r12,r17 ; mask off more than 10b
movw r17:r16,r13:r12 ; move adc sample to temporary register
sub r16,r10 ; find difference between adc sample and current delay time
sbc r17,r11
brsh check_000025 ; check for deadband if positive
neg r16 ; invert if negative
adc r17,r22 ; r22 is cleared above
neg r17

check_000025: ; check if difference is greater than deadband

cpi r16,$10 ; check if difference is less than $02
cpc r17,r22 ; r22 cleared above
brlo empty_000025 ; do nothing if less than $02
movw r11:r10,r13:r12 ; move adc sample to delay time if large enough change

empty_000025: ; empty accumulation registers and finish off

clr r12 ; empty accumulation registers
clr r13
clr r14
rjmp rotary_000025

shift_000025: ; check if delay time is correct

cp r18,r21 ; compare desired delay to actual delay
cpc r26,r12
cpc r27,r13
breq switchsample_000025 ; do nothing if the same
brlo indexdown_000025
ldi r17,$04 ; increment delay register
add r21,r17
adc r12,r18 ; r18 is cleared above
adc r13,r18
ldi r17,$03
and r13,r17 ; mask off unused bits
rjmp switchsample_000025

indexdown_000025:

subi r21,$02 ; decrement delay register
sbc r12,r18 ; r18 is cleared above
sbc r13,r18
ldi r17,$03
and r13,r17 ; mask off unused bits


rotary_000025: ; check rotary encoder and adjust lfo rate
; rotary encoder is externally debounced, so that is not done here.
; pin1 is sampled on a transition from high to low on pin0.  if pin1 is
; high, a left turn occured, if pin1 is low, a right turn occured.
dec r3 ; reduce the sampling rate to help with debounce
brne switchsample_000025
ldi r17,$40 ; adjust sample frequency to catch all rising edges (1.5ms)
mov r3,r17
lds r17,pinj ; get switch data
sbrs r17,$00 ; check if pin0 is low
rjmp edge_000025 ; check if pin0 was low on previous sample
clr r20 ;  clear state register if back high
rjmp switchsample_000025 ; finish off

edge_000025: ; check for falling edge

sbrc r20,$00 ; check if edge was already detected
rjmp switchsample_000025 ; do nothing if the edge was already detected
ori r20,$01 ; set state register to indicate a falling edge occured
sbrs r17,$01 ; check if pin1 is high
rjmp increment_000025 ; increment desired delay if right rotation
ldi r17,$01 ; decrement desired delay register
sub r2,r17
rjmp switchsample_000025 ; finish off

increment_000025: ; increment desired delay register

ldi r17,$01 ; increment desired delay register
add r2,r17

switchsample_000025: ; check switch state

lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000025:

reti

