; program: flanger-16b-midi.asm
; UID = 000024 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; mono data

; program overview
;
; data is read in from the codec and placed into memory.  data is taken
; out of memory from a time varying position.  this position has an offset
; which is increased at a fixed rate until it reaches its maximum value,
; at which point it is decreased until it reaches its minimum value.
; data is taken in on the left channel, and presented on both left and
; right out.

; constants
;
; flanger constants
;.equ flanger_rate = $70 ; samples per increment of flanger delay time
;.equ flanger_delay = $015e ; minimum flanger delay time
;.equ flanger_depth = $00e4 ; maximum offset of flanger delay time

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  
; r3  
; r4  left/right lsb out
; r5  left/right msb out
; r6  left lsb in
; r7  left msb in
; r8  flanger offset lsb
; r9  flanger offset msb
; r10 flanger rate register
; r11 flanger depth lsb
; r12 flanger depth msb
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 flanger rate counter
; r19 midi byte counter
; r20 
; r21 
; r22 write address third byte
; r23 read address third byte/null register
; r24 write address lsb
; r25 write address msb
; r26 delay time lsb
; r27 delay time msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here first time
; initialize USART for midi transfer and new jump address
ldi r30,$12 ; set new jump address
ldi r17,$00
sts ucsr0a,r17 ; set USART to single speed
sts ubrr0h,r17 ; set USART to 31.25kbps baud rate for midi
ldi r17,$27
sts ubrr0l,r17
ldi r17,$06
sts ucsr0c,r17 ; set USART to 8 bit mode
ldi r17,$10
sts ucsr0b,r17 ; turn on USART reciever
ldi r27,$01 ; initialize delay time
ldi r17,$01 ; initialize offset
mov r12,r17

; program starts here every time but first
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000024: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000024
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000024: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000024
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000024: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000024
in r17,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000024: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000024
in r17,spdr ; recieve in left channel lsb

;calculate lfo to delay time
inc r18 ; check if lfo increment time is reached
cp r18,r10
brlo getdata_000024
clr r18 ; reset counter
brts upcount_000024 ; check if up counting

downcount_000024: ; decrement delay time

clt ; clear t regsiter to indicate down counting
sbiw r27:r26,$01 ; decrement delay time
brsh getdata_000024 ; continue if not at bottom of count

upcount_000024: ; increment delay time

set ; set t register to indicate up counting
adiw r27:r26,$01 ; increment delay time
cp r26,r11 ; check if at top of count
cpc r27,r12
brsh downcount_000024 ; decrement counter if at top

getdata_000024: ; get left channel data from sram

movw r29:r28,r25:r24 ; set read register to current position
sub r28,r8 ; set read register to first delay position
sbc r29,r9
sub r28,r26 ; add in lfo time
sbc r29,r27
out portd,r28 ; set address
sts porth,r29
nop ; two cycle wait for sram setup time
nop
in r4,pina ; get data
in r5,pinc ; get data

; get flanger settings
lds r17,ucsr0a ; get USART control register
sbrs r17,rxc0 ; check if byte has been recieved
rjmp switchsample_000024 ; skip buffer read
lds r17,udr0 ; get data byte
sbrc r19,$00 ; check if command byte already recieved
rjmp update_000024 ; get data
andi r17,$f0 ; mask off channel number - recieve all channels for now
cpi r17,$b0 ; check if controller
brne switchsample_000024 ; do nothing if not correct command byte
ldi r19,$01 ; indicate command recieved
rjmp switchsample_000024 ; finish off

update_000024: ; update delay time with pitch bend value

sbrc r17,$07 ; check if msb is set - command byte
rjmp resetusart_000024 ; dont process data if command byte
sbrc r19,$01 ; check if first byte
rjmp secondbyte_000024 ; skip to second byte if not
cpi r17,$47 ; check if controller number 1
breq depth_000024
cpi r17,$4a ; check if controller number 2
breq offset_000024
cpi r17,$0c ; check if controller number 3
breq rate_000024
rjmp resetusart_000024 ; clear if none of the used controllers

depth_000024: ; set to recieve depth value

ori r19,$06 ; set byte counter to first byte recieved, depth value
rjmp switchsample_000024 ; finish off

offset_000024: ; set to recieve offset value

ori r19,$0a ; set byte counter to first byte recieved, offset value
rjmp switchsample_000024 ; finish off

rate_000024: ; set to recieve rate value

ori r19,$12 ; set byte counter to first byte recieved, rate value
rjmp switchsample_000024 ; finish off

secondbyte_000024: ; get second byte

sbrc r19,$02 ; check if depth value
rjmp depth1_000024
sbrc r19,$03 ; check if offset value
rjmp offset1_000024
sbrc r19,$04 ; check if rate value
rjmp rate1_000024

resetusart_000024: ; reset usart

clr r19 ; reset byte counter

switchsample_000024: ; check switch state

dec r15 ; check if time to sample switch
brne done_000024 ; finish off if not
lds r16,pinj ; get switch data
andi r16,$78 ; mask off rotary switch
lsr r16
lsr r16
subi r16,$fe ; adjust switch position to program memory location
cpse r16,r31 ; check if location has changed
clr r30 ; reset jump register to intial state
mov r31,r16

done_000024:

reti

depth1_000024: ; modify depth value

clr r12 ; clear old value
lsl r17 ; multiply new value by 16
lsl r17
rol r12
lsl r17
rol r12
lsl r17
rol r12
mov r11,r17 ; move remaining bits to lsb
rjmp resetusart_000024

offset1_000024: ; modify offset value

clr r9 ; clear old value
lsl r17 ; multiply new value by 16
lsl r17
rol r9
lsl r17
rol r9
lsl r17
rol r9
mov r8,r17 ; move remaining bits to lsb
rjmp resetusart_000024

rate1_000024: ; modify rate value

lsl r17 ; multiply value by 2
mov r10,r17 ; move to rate register
rjmp resetusart_000024


