; program: flanger-16b.asm
; UID = 000016 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; mono data

; program overview
;
; data is read in from the codec and placed into memory.  data is taken
; out of memory from a time varying position.  this position has an offset
; which is increased at a fixed rate until it reaches its maximum value,
; at which point it is decreased until it reaches its minimum value.
; data is taken in on the left channel, and presented on both left and
; right out.

; constants
;
; flanger constants
.equ flanger_rate_000016 = $70 ; samples per increment of flanger delay time
.equ flanger_delay_000016 = $015e ; minimum flanger delay time
.equ flanger_depth_000016 = $00e4 ; maximum offset of flanger delay time

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  
; r3  
; r4  left/right lsb out
; r5  left/right msb out
; r6  left lsb in
; r7  left msb in
; r8  
; r9  
; r10 
; r11 
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 flanger rate register
; r19 
; r20 
; r21 
; r22 write address third byte
; r23 read address third byte/null register
; r24 write address lsb
; r25 write address msb
; r26 delay time lsb
; r27 delay time msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000016: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000016
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000016: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000016
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000016: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000016
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000016: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000016
in r8,spdr ; recieve in left channel lsb

;calculate lfo to delay time
inc r18 ; check if lfo increment time is reached
cpi r18,flanger_rate_000016
brlo getdata_000016
clr r18 ; reset counter
brts upcount_000016 ; check if up counting

downcount_000016: ; decrement delay time

clt ; clear t regsiter to indicate down counting
sbiw r27:r26,$01 ; decrement delay time
brsh getdata_000016 ; continue if not at bottom of count

upcount_000016: ; increment delay time

set ; set t register to indicate up counting
adiw r27:r26,$01 ; increment delay time
ldi r17,high(flanger_depth_000016) ; check if at top of count
cpi r26,low(flanger_depth_000016)
cpc r27,r17
brsh downcount_000016 ; decrement counter if at top

getdata_000016: ; get left channel data from sram

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(flanger_delay_000016) ; set read register to first delay position
sbci r29,high(flanger_delay_000016)
sub r28,r26 ; add in lfo time
sbc r29,r27
out portd,r28 ; set address
sts porth,r29
nop ; two cycle wait for sram setup time
nop
in r4,pina ; get data
in r5,pinc ; get data

;check switch state
dec r15
brne done_000016
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000016:

reti

