; program: delay-16b-rotary.asm
; UID = 000008 - unique id to eliminate conflicts between variables
; 16b address space (.7s delay time)
; stereo data
; pot controlled delay time (0s - .7s)

; program overview
;
; data is read in from memory and written to the codec at the same time
; new data is written to the memory from the codec.  the rotary encoder
; increments or decrements the read address, adjusting the delay time.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 
; r11 
; r12 desired delay lsb
; r13 desired delay msb
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 
; r20 
; r21 
; r22 write address third byte/null register
; r23 
; r24 write address lsb
; r25 write address msb
; r26 actual delay lsb
; r27 actual delay msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb0 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb0
adiw r25:r24,$01 ; increment write address
adiw r29:r28,$01 ; increment read address
ldi r22,$00 ; set up high byte write register/null register

wait1_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000008
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r3,pinc ; get data
adiw r29:r28,$01 ; increment read address

wait2_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000008
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

wait3_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000008
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data
adiw r25:r24,$01 ; increment write address

wait4_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000008
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

; check rotary encoder and adjust delay time
; rotary encoder is externally debounced, so that is not done here.
; pin1 is sampled on a transition from high to low on pin0.  if pin1 is
; high, a left turn occured, if pin1 is low, a right turn occured.
dec r15 ; reduce the sampling rate to help with debounce
brne adjust_000008
ldi r17,$40 ; adjust sample frequency to catch all rising edges (1.5ms)
mov r15,r17
lds r17,pinj ; get switch data
sbrs r17,$00 ; check if pin0 is low
rjmp edge_000008 ; check if pin0 was low on previous sample
clt ;  clear the t register if back high
rjmp switchsample_000008 ; finish off

edge_000008: ; check for falling edge

brts switchsample_000008 ; do nothing if the edge was already detected
set ; set t register to indicate a falling edge occured
sbrs r17,$01 ; check if pin1 is high
rjmp upcount_000008 ; increment desired delay if right rotation
ldi r17,$01 ; decrement desired delay register
sub r13,r17
rjmp switchsample_000008 ; finish off

upcount_000008: ; increment desired delay register

ldi r17,$01 ; increment desired delay register
add r13,r17

switchsample_000008:

lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

adjust_000008: ; check if delay time is correct

andi r26,$fe ; make sure delay time is even
cp r26,r22 ; compare desired delay to actual delay
cpc r27,r13
breq done_000008 ; do nothing if the same
brsh indexdown_000008
adiw r27:r26,$04 ; increment delay register
rjmp done_000008

indexdown_000008:

sbiw r27:r26,$02 ; decrement delay register

done_000008: ; finish off

movw r29:r28,r25:r24 ; move write address to read destination register
sub r28,r26 ; subtract delay time
sbc r29,r27
reti
