; program: chorus-16b.asm
; UID = 000015 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; mono data

; program overview
;
; data is read in from the codec and placed into memory.  data is taken
; out of memory from 16 different locations and added together.  this
; result is scaled and presented at the output.  data is taken in on the
; left channel, and presented on both left and right out.

; constants
;
; tap delay times, in sample period increments
.equ chorus_delay1 = $0356 ; chorus tap1 delay time
.equ chorus_delay2 = $0370 ; chorus tap2 delay time
.equ chorus_delay3 = $039a ; chorus tap3 delay time
.equ chorus_delay4 = $03e4 ; chorus tap4 delay time
.equ chorus_delay5 = $032a ; chorus tap5 delay time
.equ chorus_delay6 = $0444 ; chorus tap6 delay time
.equ chorus_delay7 = $048e ; chorus tap7 delay time
.equ chorus_delay8 = $0412 ; chorus tap8 delay time
.equ chorus_delay9 = $0466 ; chorus tap9 delay time
.equ chorus_delay10 = $04e0 ; chorus tap10 delay time
.equ chorus_delay11 = $04fe ; chorus tap11 delay time
.equ chorus_delay12 = $0504 ; chorus tap12 delay time
.equ chorus_delay13 = $053a ; chorus tap13 delay time
.equ chorus_delay14 = $059a ; chorus tap14 delay time
.equ chorus_delay15 = $05c2 ; chorus tap15 delay time
.equ chorus_delay16 = $0608 ; chorus tap16 delay time

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  
; r3  
; r4  left/right lsb out/accumulation fractional byte
; r5  left/right msb out
; r6  left lsb in
; r7  left msb in
; r8  
; r9  pushbutton debounce register
; r10 adc accumulation lsb
; r11 adc accumulation msb
; r12 address pointer increment lsb
; r13 address pointer increment msb
; r14 adc accumulation fractional byte
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 signed multiply msb 1
; r19 signed multiply msb 2
; r20 
; r21 
; r22 write address third byte
; r23 read address third byte/null register
; r24 write address lsb
; r25 write address msb
; r26 accumulation lsb
; r27 accumulation msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb5
adiw r25:r24,$01 ; increment write address
ldi r22,$00 ; set up write high byte register
ldi r23,$04 ; set up read high byte register

wait1_000015: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000015
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000015: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000015
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to internal sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

wait3_000015: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000015
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000015: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000015
in r8,spdr ; recieve in left channel lsb

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay1) ; set read register to first delay position
sbci r29,high(chorus_delay1)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r26,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay2) ; set read register to first delay position
sbci r29,high(chorus_delay2)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r27 ; clear high byte register if positive
sbrc r26,$07 ; check if negative
ser r27 ; set high byte if negative
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay3) ; set read register to first delay position
sbci r29,high(chorus_delay3)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay4) ; set read register to first delay position
sbci r29,high(chorus_delay4)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay5) ; set read register to first delay position
sbci r29,high(chorus_delay5)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay6) ; set read register to first delay position
sbci r29,high(chorus_delay6)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay7) ; set read register to first delay position
sbci r29,high(chorus_delay7)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay8) ; set read register to first delay position
sbci r29,high(chorus_delay8)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay9) ; set read register to first delay position
sbci r29,high(chorus_delay9)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay10) ; set read register to first delay position
sbci r29,high(chorus_delay10)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay11) ; set read register to first delay position
sbci r29,high(chorus_delay11)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay12) ; set read register to first delay position
sbci r29,high(chorus_delay12)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay13) ; set read register to first delay position
sbci r29,high(chorus_delay13)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay14) ; set read register to first delay position
sbci r29,high(chorus_delay14)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay15) ; set read register to first delay position
sbci r29,high(chorus_delay15)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data

movw r29:r28,r25:r24 ; set read register to current position
subi r28,low(chorus_delay16) ; set read register to first delay position
sbci r29,high(chorus_delay16)
;get left channel data from sram
out portd,r28 ; set address
sts porth,r29
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17
in r2,pina ; get data
in r16,pinc ; get data
clr r17 ; clear high byte register if positive
sbrc r16,$07 ; check if negative
ser r17 ; set high byte if negative
add r4,r2 ; accumulate 24b result
adc r26,r16 ; placed here to efficiently use sram wait time
adc r27,r17

;divide result by 16 and shift up into r27:r26
bst r27,$07 ; store sign bit
swap r27 ; move low nibble to high nibble
andi r27,$f0 ; clear low nibble
bld r27,$07 ; restore sign bit
swap r26 ; move low nibble to high nibble
mov r16,r26
andi r16,$0f ; clear high nibble
or r27,r16 ; move low nibble in place
andi r26,$f0 ; clear low nibble
mov r16,r4
swap r16
andi r16,$0f
or r26,r16
movw r5:r4,r27:r26 ; move result to read register

;check switch setting
dec r15
brne done_000015
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000015:

reti

