; program: sampler-pot.asm
; UID = 000014 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; mono data

; program overview
;
; data is read in from the codec and placed into memory.  a memory address
; pointer is incrmented to find the next sample, and this is sent to the
; codec.  the pointer is incremented at a variable rate, with fractional
; values less than one slowing down the playback speed, and fractional
; values above one increasing the playback speed.  the output data is an
; interpolation of the two samples adjacent to the pointer.  left channel
; data is taken in, and the result is placed on both left and right.  ADC0
; is averaged over 256 samples and is used to create the pointer increment
; value.  the pushbutton takes in data when depressed, and plays back when
; released.

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  left/right lsb out
; r3  left/right msb out
; r4  
; r5  
; r6  left lsb in
; r7  left msb in
; r8  
; r9  pushbutton debounce register
; r10 adc accumulation lsb
; r11 adc accumulation msb
; r12 address pointer increment lsb
; r13 address pointer increment msb
; r14 adc accumulation fractional byte
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 signed multiply msb 1
; r19 signed multiply msb 2
; r20 
; r21 read address fractional byte
; r22 write address third byte
; r23 read address third byte/null register
; r24 write address lsb
; r25 write address msb
; r26 
; r27 
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb5
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000014: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000014
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb

wait2_000014: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000014
in r6,spdr ; recieve in left channel lsb
out spdr,r3 ; send out right channel msb

wait3_000014: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000014
in r17,spdr ; recieve in right channel msb
out spdr,r2 ; send out right channel lsb

wait4_000014: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000014
in r17,spdr ; recieve in left channel lsb

;check pushbutton
lds r16,pinj ; get pushbutton data
bst r16,$02 ; debounce pushbutton
lsl r9
bld r9,$00
ldi r17,$ff ; check if button not pressed
cp r9,r17
breq interpolate_000014 ; playback if button is not depressed
movw r29:r28,r25:r24 ; synchronize read and write addressses
adiw r25:r24,$01 ; increment write address
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines
movw r3:r2,r7:r6 ; pass data through while recording

switchsample_000014: ;check switch

dec r15
brne done_000014
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000014:

reti

interpolate_000014: ; interpolate data based upon speed setting

add r21,r12 ; increment read register
adc r28,r13
adc r29,r22 ; r22 is cleared above
;get left channel sample 1 data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r19,pinc ; get data
adiw r29:r28,$01 ; increment read register
;get left channel sample 2 data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r3,pina ; get data
in r18,pinc ; get data
sbiw r29:r28,$01 ; reset read register

;multiply sample 1 by distance
mov r16,r21 ; get distance from sample 1
com r16
mulsu r19,r16 ; (signed)ah * b
movw r7:r6,r1:r0
mul	r2,r16	; al * b
add	r6,r1
adc	r7,r22 ; r22 is cleared above
mov r0,r8

;multiply sample 2 by distance
mulsu r18,r21 ; (signed)ah * b
add r6,r0 ; accumulate result
adc r7,r1
mul	r3,r21	; al * b
add r8,r0 ; accumulate result
adc	r6,r1
adc	r7,r22 ; r22 is cleared above
movw r3:r2,r7:r6 ; move result to ouput registers

; get speed settings
lds r17,adcsra ; get adc control register
sbrs r17,adif ; check if adc conversion is complete
rjmp switchsample_000014 ; skip adc sampling
lds r17,adcl ; get low byte adc value
lds r16,adch ; get high byte adc value
add r14,r17
adc r10,r16 ; accumulate adc samples
adc r11,r22 ; accumulate adc samples - r22 is cleared above
ldi r17,$f7
sts adcsra,r17 ; clear interrupt flag
tst r15 ; countdown adc sample clock
brne switchsample_000014 ; get adc value if its been long enough

adcsample_000014: ; get adc value and change decay time

lsr r11 ; divide accumulated value by 2
ror r10
ldi r17,$40 ; place in offset
add r10,r17
adc r11,r22 ; r22 is cleared above
movw r13:r12,r11:r10 ; move adc value to desired speed register
clr r10 ; empty accumulation registers
clr r11
clr r14
rjmp switchsample_000014 ; finish off


