; program: ring_modulator.asm
; UID = 000013 - unique id to eliminate conflicts between variables
; mono data

; program overview
;
; data is read in from the codec on left and right channels.  these are
; multiplied together and presented at both outputs.  for testing, a
; rampwave is generated in place of the right input.

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  multiply accumulation lsb
; r3  multiply accumulation mlb
; r4  right/left lsb out/multiply accumulation mhb
; r5  right/left msb out/multiply accumulation msb
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 
; r11 
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 ramp wave lsb
; r19 ramp wave msb
; r20 multiply register lsb
; r21 multiply register msb
; r22 null register
; r23 
; r24 
; r25 
; r26 
; r27 
; r28 
; r29 
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb5
ldi r22,$00 ; set up high byte write register

wait1_000013: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000013
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000013: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000013
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb

wait3_000013: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000013
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000013: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000013
in r8,spdr ; recieve in right channel lsb

movw r21:r20,r7:r6 ; move left data to multiply register
;movw r19:r18,r9:r8 ; move right data to multiply register

; make ramp wave for now as i dont have a stereo signal
mov r19,r15
cpi r19,$40
brlo multiply_000013
cpi r19,$c0
brsh multiply_000013
ldi r18,$80
eor r19,r18
neg r19
clr r18

multiply_000013:
;multiply left and right
muls r19,r21 ; (signed)ah * (signed)bh
movw r5:r4,r1:r0
mul	r18,r20	; al * bl
movw r3:r2,r1:r0
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22 ; r22 is cleared above
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22 ; r22 is cleared above
add	r3,r0
adc	r4,r1
adc	r5,r22

;check switch state
dec r15
brne done_000013
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000013:

reti
