; program: gated_reverser-16b.asm
; UID = 000011 - unique id to eliminate conflicts between variables
; 16b address space (.7s sample time)
; mono data

; program overview
;
; data is read in from the codec and written to memory.  the data is
; fullwave rectified and the absolute value is compared to a threshold.
; if the data is above this threshold, the reverser function is turned
; on, and continues to operate until a full rotation of the memory has
; been made.  at this point, the new data is evaluated once again for
; the threshold condition.  when not reversing, the program plays out
; the data as it arrives.  left channel data is taken in, and the output
; is placed on both left and right.

; constants used in the program
;
.equ threshold = $40 ; threshold at which point reverser activates

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 
; r11 
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 
; r20 
; r21 
; r22 write address third byte
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 
; r27 
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

;program starts here
;transfer data to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb5
adiw r25:r24,$01 ; increment write address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000011: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000011
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb
out portg,r23 ; pull ce low, we high, and set high bits of register

wait2_000011: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000011
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000011: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000011
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000011: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000011
in r8,spdr ; recieve in left channel lsb

;check if in reverse mode and fullwave rectify if needed
movw r3:r2,r7:r6 ; make a copy of the data in case of inversion
brts compare_000011 ; see if a full rotation has been made
sbrs r7,$07 ; check if negative
rjmp checklevel_000011 ; check signal level
com r6 ; invert data if negative (using ones complement to avoid problem at $8000)
com r7

checklevel_000011: ; check signal level above threshold

ldi r17,threshold ; compare value - eventually have this be an adc reading
cp r7,r17 ; compare signal to threshold
brlo unset_000011 ; do nothing if below
set ; set t bit to indicate above threshold
movw r29:r28,r25:r24 ; move write register to read register
rjmp getdata_000011 ; get delayed data

compare_000011: ; check if full rotation has been made

cp r28,r24 ; check if a full rotation has been made
cpc r29,r25
breq unset_000011 ; turn off reverse function
sbiw r29:r28,$01 ; move backwards in time
cp r28,r24 ; check if a full rotation has been made
cpc r29,r25
breq unset_000011 ; turn off reverse function

getdata_000011: ; get delayed data

out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data

switchsample_000011: ; check rotary switch

dec r15
brne done_000011
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000011:

reti

unset_000011: ; turn off reverse function

clt ; turn off t bit to indicate no more reverse
movw r5:r4,r3:r2 ; move current data to output
rjmp switchsample_000011 ; finish off


