; program: envelope_stripper.asm
; UID = 000012 - unique id to eliminate conflicts between variables
; mono data

; program overview
;
; data is read in from the codec, and negative values are inverted to
; positive values.  this value is compared to the current max value, and
; if it is larger, it becomes the new max value.  the max value is
; decremented each sample period to decay the envelope.  left channel
; data is taken in, and its envelope is used to control the gain on an
; iternally generated rampwave.  this is presented on both left and right
; channels.

; constants
;
.equ decay = $0f ; decay amount per sample period

; register usage - may be redefined in other sections
;
; r0  multiply result lsb
; r1  multiply result msb
; r2  accumulation lsb
; r3  accumulation mlb
; r4  right/left lsb out/accumulation mhb
; r5  right/left msb out/accumulation msb
; r6  left lsb in
; r7  left msb in
; r8  
; r9  
; r10 
; r11 
; r12 
; r13 
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 ramp wave buffer/multiply msb
; r19 ramp wave buffer/multiply msb
; r20 current max value lsb/multiply lsb
; r21 current max value msb/multiply msb
; r22 null register
; r23 
; r24 
; r25 
; r26 
; r27 
; r28 
; r29 
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r5 ; send out left channel msb
cbi portb,portb5
adiw r25:r24,$01 ; increment write address
ldi r22,$00 ; set up null register

wait1_000012: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000012
in r7,spdr ; recieve in left channel msb
out spdr,r4 ; send out left channel lsb

wait2_000012: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000012
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb

wait3_000012: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000012
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb

wait4_000012: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000012
in r8,spdr ; recieve in right channel lsb

;fullwave rectify before doing level comparison
sbrs r7,$07 ; check if negative
rjmp checklevel_000012 ; check signal level
com r6 ; invert data if negative (using ones complement to avoid problem at $8000)
com r7

checklevel_000012: ; check signal level above threshold

cp r6,r20 ; compare signal to current max value
cpc r7,r21
brlt getdata_000012 ; do nothing if below
movw r21:r20,r7:r6 ; move new max value to current max value

getdata_000012: ; get data

subi r20,decay ; decrement envelope for decay
sbc r21,r22 ; r22 is cleared above
; need a signal to place envelope on for now
mov r19,r15 ; make ramp wave
cpi r19,$40
brlo multiply_000012
cpi r19,$c0
brsh multiply_000012
ldi r18,$80
eor r19,r18
neg r19
clr r18

multiply_000012:
;multiply data by envelope
muls r19,r21 ; (signed)ah * (signed)bh
movw r5:r4,r1:r0
mul	r18,r20	; al * bl
movw r3:r2,r1:r0
mulsu r19,r20 ; (signed)ah * bl
sbc	r5,r22 ; r22 is cleared above
add	r3,r0
adc	r4,r1
adc	r5,r22
mulsu r21,r18 ; (signed)bh * al
sbc	r5,r22 ; r22 is cleared above
add	r3,r0
adc	r4,r1
adc	r5,r22

switchsample_000012: ; check rotary switch

dec r15
brne done_000012
lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location

done_000012:

reti

