; program: delay-16b-rotary.asm
; UID = 000008 - unique id to eliminate conflicts between variables
; 16b address space (.7s delay time)
; stereo data
; pot controlled delay time (0s - .7s)

; program overview
;
; data is read in from memory and written to the codec at the same time
; new data is written to the memory from the codec.  the rotary encoder
; increments or decrements the read address, adjusting the delay time.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 rotary encoder pin0 debounce register
; r11 rotray encoder pin1 debounce register
; r12 actual delay lsb
; r13 actual delay msb
; r14 
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 rotary encoder previous state register
; r20 
; r21 
; r22 write address third byte/null register
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 
; r27 
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb5
adiw r25:r24,$01 ; increment write address
adiw r29:r28,$01 ; increment read address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000008
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb
;get left channel data from sram
out portg,r23 ; pull ce low, we high, and set high bits of register
;cbi portb,portb7 ; pull oe low - should be low already, uncomment if neccesary
;set data lines as input should also already be done, but do so here if not
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r3,pinc ; get data
adiw r29:r28,$01 ; increment read address

wait2_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000008
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

wait3_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000008
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data
adiw r25:r24,$01 ; increment write address

wait4_000008: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000008
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
ldi r17,$00 ; prepare for setting ports a,c as input
sbi portg,portg2 ; pull we high to write
out ddra,r17 ; set porta as input for data lines
out ddrc,r17 ; set portc as input for data lines

; check rotary encoder and adjust delay time
dec r15
brne done_000008
lds r17,pinj ; get switch data
bst r17,$00 ; debounce pin0 of encoder
lsl r10
bld r10,$00
bst r17,$01 ; debounce pin1 of encoder
lsl r11
bld r11,$00
tst r11 ; see if pin1 is low
breq edge_000008
ldi r17,$ff ; check if fully high
cp r11,r17
brne finish_000008 ; do nothing if not fully high
ldi r19,$01 ; set previous state to current state
rjmp finish_000008

edge_000008: ; check for falling edge

sbrs r19,$00 ; check if previous state was high
rjmp finish_000008 ; do nothing if no state change
ldi r19,$00 ; clear register
sbrc r10,$00 ; check average state of pin1
inc r19
sbrc r10,$01
inc r19
sbrc r10,$02
inc r19
sbrc r10,$03
inc r19
sbrc r10,$04
inc r19
sbrc r10,$05
inc r19
sbrc r10,$06
inc r19
sbrc r10,$07
inc r19
cpi r19,$04 ; check average value of pin1
ldi r19,$00 ; reset previous state register
brlt increment_000008 ; increment if a backwards rotation
sbiw r29:r28,$14 ; decrement read register
rjmp finish_000008

increment_000008:

adiw r29:r28,$14 ; increment read register

finish_000008:

lds r31,pinj ; get switch data
andi r31,$78 ; mask off rotary switch
ldi r17,$02
lsr r31
lsr r31
add r31,r17 ; adjust switch position to program memory location
ldi r17,$20 ; reset counter to 32 to increase sample time
mov r15,r17

done_000008:

reti
