; program: delay-16b-midi.asm
; UID = 000023 - unique id to eliminate conflicts between variables
; 16b address space (.7s delay time)
; stereo data
; midi controlled delay time (0s - .7s)

; program overview
;
; data is read in from memory and written out the codec at the same time
; new data is written to the memory from the codec.  the USART is connected
; to a midi device which sends a control value.  this value is subtracted
; from the write address to create the desired read address.  if the actual
; read address doesnt match the desired read address, it is either
; incremented or decremented by one sample each sample period until it
; matches.  this reduces noise during delay time transitions.

; register usage - may be redefined in other sections
;
; r0  
; r1  
; r2  left lsb out
; r3  left msb out
; r4  right lsb out
; r5  right msb out
; r6  left lsb in
; r7  left msb in
; r8  right lsb in
; r9  right msb in
; r10 adc accumulator fractional byte
; r11 adc accumulator lsb
; r12 actual delay lsb
; r13 actual delay msb
; r14 USART byte counter
; r15 switch sample counter
; r16 temporary swap register
; r17 temporary swap register
; r18 
; r19 adc accumulator msb
; r20 
; r21 
; r22 write address third byte/null register
; r23 read address third byte
; r24 write address lsb
; r25 write address msb
; r26 desired delay lsb
; r27 desired delay msb
; r28 read address lsb
; r29 read address msb
; r30 jump location for interrupt lsb
; r31 jump location for interrupt msb

; program starts here first time
; initialize USART for midi transfer and new jump address
ldi r30,$0f ; set new jump address
ldi r17,$00
sts ucsr0a,r17 ; set USART to single speed
sts ubrr0h,r17 ; set USART to 31.25kbps baud rate for midi
ldi r17,$27
sts ubrr0l,r17
ldi r17,$06
sts ucsr0c,r17 ; set USART to 8 bit mode
ldi r17,$10
sts ucsr0b,r17 ; turn on USART reciever

; program starts here every time but first
; initiate data transfer to codec
sbi portb,portb5 ; toggle slave select pin
out spdr,r3 ; send out left channel msb
cbi portb,portb5
adiw r25:r24,$01 ; increment write address
adiw r29:r28,$01 ; increment read address
ldi r23,$04 ; set up high byte read register
ldi r22,$00 ; set up high byte write register

wait1_000023: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait1_000023
in r7,spdr ; recieve in left channel msb
out spdr,r2 ; send out left channel lsb
;get left channel data from sram
out portg,r23 ; pull ce low, we high, and set high bits of register
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r2,pina ; get data
in r3,pinc ; get data
adiw r29:r28,$01 ; increment read address

wait2_000023: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait2_000023
in r6,spdr ; recieve in left channel lsb
out spdr,r5 ; send out right channel msb
;write left channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r6 ; set data
out portc,r7
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

wait3_000023: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait3_000023
in r9,spdr ; recieve in right channel msb
out spdr,r4 ; send out right channel lsb
;get right channel data from sram
out portd,r28 ; set address
sts porth,r29
nop ; wait input latch time of 2 clock cycles
nop ; wait input latch time of 2 clock cycles
in r4,pina ; get data
in r5,pinc ; get data
adiw r25:r24,$01 ; increment write address

wait4_000023: ; check if byte has been sent

in r17,spsr
sbrs r17,spif
rjmp wait4_000023
in r8,spdr ; recieve in left channel lsb
;write right channel data to sram
out portd,r24 ; set address
sts porth,r25
out portg,r22 ; pull ce low,we low,and set high bits of address
ldi r17,$ff
out ddra,r17 ; set porta as output for data write
out ddrc,r17 ; set portc as output for data write
out porta,r8 ; set data
out portc,r9
sbi portg,portg2 ; pull we high to write
out ddra,r22 ; set porta as input for data lines
out ddrc,r22 ; set portc as input for data lines

; get delay settings
lds r17,ucsr0a ; get USART control register
sbrs r17,rxc0 ; check if byte has been recieved
rjmp shift_000023 ; skip buffer read
lds r17,udr0 ; get data byte
brts update_000023 ; skip if command byte already recieved
andi r17,$f0 ; mask off channel number - recieve all channels for now
cpi r17,$e0 ; check if pitch bend controller
brne shift_000023 ; do nothing if not correct command byte
set ; set t register to indicate correct command byte recieved
rjmp shift_000023 ; finish off

update_000023: ; update delay time with pitch bend value

tst r14 ; check if first byte
brne secondbyte_000023 ; skip to second byte if not
mov r0,r17 ; store first byte
inc r14 ; set byte counter to first byte recieved
rjmp shift_000023 ; finish off

secondbyte_000023: ; get second byte

clr r14 ; reset byte counter
clt ; reset command byte indicator
lsl r0 ; shift 14b number to 16b number
lsl r0
rol r17
mov r27,r17 ; move data to desired delay register
mov r26,r0
cpi r27,$03 ; check if desired delay is less than 9ms
brsh shift_000023 ; finish off if delay time is greater than 9ms
ldi r27,$03 ; set desired delay to 9ms
clr r26

shift_000023: ; check if delay time is correct

cp r26,r12 ; compare desired delay to actual delay
cpc r27,r13
breq switchsample_000023 ; do nothing if the same
brlo indexdown_000023
ldi r17,$02 ; increment delay register
add r12,r17
adc r13,r22 ; r22 is cleared at top of function
rjmp switchsample_000023

indexdown_000023:

ldi r17,$04 ; decrement delay register
sub r12,r17
sbc r13,r22 ; r22 is cleared at top of function

switchsample_000023: ; check switch position

dec r15 ; check if time to sample switch
brne done_000023 ; finish off if not
lds r16,pinj ; get switch data
andi r16,$78 ; mask off rotary switch
lsr r16
lsr r16
subi r16,$fe ; adjust switch position to program memory location
cpse r16,r31 ; check if location has changed
clr r30 ; reset jump register to intial state
mov r31,r16

done_000023:

movw r29:r28,r25:r24 ; move write address to read destination register
sub r28,r12 ; subtract delay time
sbc r29,r13
reti

